/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>RegisterInstanceResult</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterInstanceResponse extends OpsWorksResponse implements
        ToCopyableBuilder<RegisterInstanceResponse.Builder, RegisterInstanceResponse> {
    private final String instanceId;

    private RegisterInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The registered instance's AWS OpsWorks Stacks ID.
     * </p>
     * 
     * @return The registered instance's AWS OpsWorks Stacks ID.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceResponse)) {
            return false;
        }
        RegisterInstanceResponse other = (RegisterInstanceResponse) obj;
        return Objects.equals(instanceId(), other.instanceId());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterInstanceResponse").add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, RegisterInstanceResponse> {
        /**
         * <p>
         * The registered instance's AWS OpsWorks Stacks ID.
         * </p>
         * 
         * @param instanceId
         *        The registered instance's AWS OpsWorks Stacks ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceResponse model) {
            super(model);
            instanceId(model.instanceId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public RegisterInstanceResponse build() {
            return new RegisterInstanceResponse(this);
        }
    }
}
