/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsLogStream;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CloudWatchLogsLogStream} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CloudWatchLogsLogStreamMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").isBinary(false).build();

    private static final MarshallingInfo<String> DATETIMEFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatetimeFormat").isBinary(false).build();

    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeZone").isBinary(false).build();

    private static final MarshallingInfo<String> FILE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("File").isBinary(false).build();

    private static final MarshallingInfo<String> FILEFINGERPRINTLINES_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileFingerprintLines").isBinary(false).build();

    private static final MarshallingInfo<String> MULTILINESTARTPATTERN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiLineStartPattern").isBinary(false).build();

    private static final MarshallingInfo<String> INITIALPOSITION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InitialPosition").isBinary(false).build();

    private static final MarshallingInfo<String> ENCODING_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encoding").isBinary(false).build();

    private static final MarshallingInfo<Integer> BUFFERDURATION_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BufferDuration").isBinary(false).build();

    private static final MarshallingInfo<Integer> BATCHCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> BATCHSIZE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchSize").isBinary(false).build();

    private static final CloudWatchLogsLogStreamMarshaller INSTANCE = new CloudWatchLogsLogStreamMarshaller();

    private CloudWatchLogsLogStreamMarshaller() {
    }

    public static CloudWatchLogsLogStreamMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CloudWatchLogsLogStream cloudWatchLogsLogStream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(cloudWatchLogsLogStream, "cloudWatchLogsLogStream");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(cloudWatchLogsLogStream.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.datetimeFormat(), DATETIMEFORMAT_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.timeZoneAsString(), TIMEZONE_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.file(), FILE_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.fileFingerprintLines(), FILEFINGERPRINTLINES_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.multiLineStartPattern(), MULTILINESTARTPATTERN_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.initialPositionAsString(), INITIALPOSITION_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.encodingAsString(), ENCODING_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.bufferDuration(), BUFFERDURATION_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.batchCount(), BATCHCOUNT_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsLogStream.batchSize(), BATCHSIZE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
