/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CreateInstanceRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateInstanceRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateInstanceRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();

    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();

    private static final MarshallingInfo<String> AUTOSCALINGTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingType").isBinary(false).build();

    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").isBinary(false).build();

    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").isBinary(false).build();

    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").isBinary(false).build();

    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKeyName").isBinary(false).build();

    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();

    private static final MarshallingInfo<String> VIRTUALIZATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VirtualizationType").isBinary(false).build();

    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();

    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").isBinary(false).build();

    private static final MarshallingInfo<String> ROOTDEVICETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootDeviceType").isBinary(false).build();

    private static final MarshallingInfo<List> BLOCKDEVICEMAPPINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockDeviceMappings").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").isBinary(false).build();

    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();

    private static final MarshallingInfo<String> TENANCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tenancy").isBinary(false).build();

    private static final CreateInstanceRequestModelMarshaller INSTANCE = new CreateInstanceRequestModelMarshaller();

    private CreateInstanceRequestModelMarshaller() {
    }

    public static CreateInstanceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateInstanceRequest createInstanceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createInstanceRequest, "createInstanceRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createInstanceRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.autoScalingTypeAsString(), AUTOSCALINGTYPE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.os(), OS_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.sshKeyName(), SSHKEYNAME_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.virtualizationType(), VIRTUALIZATIONTYPE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.architectureAsString(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.rootDeviceTypeAsString(), ROOTDEVICETYPE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.blockDeviceMappings(), BLOCKDEVICEMAPPINGS_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.tenancy(), TENANCY_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
