/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CreateUserProfileRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateUserProfileRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateUserProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamUserArn").isBinary(false).build();

    private static final MarshallingInfo<String> SSHUSERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshUsername").isBinary(false).build();

    private static final MarshallingInfo<String> SSHPUBLICKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshPublicKey").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ALLOWSELFMANAGEMENT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowSelfManagement").isBinary(false).build();

    private static final CreateUserProfileRequestModelMarshaller INSTANCE = new CreateUserProfileRequestModelMarshaller();

    private CreateUserProfileRequestModelMarshaller() {
    }

    public static CreateUserProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateUserProfileRequest createUserProfileRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createUserProfileRequest, "createUserProfileRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createUserProfileRequest.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall(createUserProfileRequest.sshUsername(), SSHUSERNAME_BINDING);
            protocolMarshaller.marshall(createUserProfileRequest.sshPublicKey(), SSHPUBLICKEY_BINDING);
            protocolMarshaller.marshall(createUserProfileRequest.allowSelfManagement(), ALLOWSELFMANAGEMENT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
