/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.Instance;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Instance} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstanceMarshaller {
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();

    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").isBinary(false).build();

    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();

    private static final MarshallingInfo<String> AUTOSCALINGTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingType").isBinary(false).build();

    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();

    private static final MarshallingInfo<List> BLOCKDEVICEMAPPINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockDeviceMappings").isBinary(false).build();

    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();

    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").isBinary(false).build();

    private static final MarshallingInfo<String> EC2INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2InstanceId").isBinary(false).build();

    private static final MarshallingInfo<String> ECSCLUSTERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EcsClusterArn").isBinary(false).build();

    private static final MarshallingInfo<String> ECSCONTAINERINSTANCEARN_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("EcsContainerInstanceArn").isBinary(false).build();

    private static final MarshallingInfo<String> ELASTICIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticIp").isBinary(false).build();

    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").isBinary(false).build();

    private static final MarshallingInfo<String> INFRASTRUCTURECLASS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InfrastructureClass").isBinary(false).build();

    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCEPROFILEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceProfileArn").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();

    private static final MarshallingInfo<String> LASTSERVICEERRORID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastServiceErrorId").isBinary(false).build();

    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").isBinary(false).build();

    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").isBinary(false).build();

    private static final MarshallingInfo<String> PRIVATEDNS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateDns").isBinary(false).build();

    private static final MarshallingInfo<String> PRIVATEIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateIp").isBinary(false).build();

    private static final MarshallingInfo<String> PUBLICDNS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicDns").isBinary(false).build();

    private static final MarshallingInfo<String> PUBLICIP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicIp").isBinary(false).build();

    private static final MarshallingInfo<String> REGISTEREDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisteredBy").isBinary(false).build();

    private static final MarshallingInfo<String> REPORTEDAGENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportedAgentVersion").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REPORTEDOS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportedOs").isBinary(false).build();

    private static final MarshallingInfo<String> ROOTDEVICETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootDeviceType").isBinary(false).build();

    private static final MarshallingInfo<String> ROOTDEVICEVOLUMEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootDeviceVolumeId").isBinary(false).build();

    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").isBinary(false).build();

    private static final MarshallingInfo<String> SSHHOSTDSAKEYFINGERPRINT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SshHostDsaKeyFingerprint").isBinary(false).build();

    private static final MarshallingInfo<String> SSHHOSTRSAKEYFINGERPRINT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("SshHostRsaKeyFingerprint").isBinary(false).build();

    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKeyName").isBinary(false).build();

    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();

    private static final MarshallingInfo<String> TENANCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tenancy").isBinary(false).build();

    private static final MarshallingInfo<String> VIRTUALIZATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VirtualizationType").isBinary(false).build();

    private static final InstanceMarshaller INSTANCE = new InstanceMarshaller();

    private InstanceMarshaller() {
    }

    public static InstanceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Instance instance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instance, "instance");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instance.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall(instance.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall(instance.architectureAsString(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall(instance.arn(), ARN_BINDING);
            protocolMarshaller.marshall(instance.autoScalingTypeAsString(), AUTOSCALINGTYPE_BINDING);
            protocolMarshaller.marshall(instance.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(instance.blockDeviceMappings(), BLOCKDEVICEMAPPINGS_BINDING);
            protocolMarshaller.marshall(instance.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(instance.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall(instance.ec2InstanceId(), EC2INSTANCEID_BINDING);
            protocolMarshaller.marshall(instance.ecsClusterArn(), ECSCLUSTERARN_BINDING);
            protocolMarshaller.marshall(instance.ecsContainerInstanceArn(), ECSCONTAINERINSTANCEARN_BINDING);
            protocolMarshaller.marshall(instance.elasticIp(), ELASTICIP_BINDING);
            protocolMarshaller.marshall(instance.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall(instance.infrastructureClass(), INFRASTRUCTURECLASS_BINDING);
            protocolMarshaller.marshall(instance.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall(instance.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(instance.instanceProfileArn(), INSTANCEPROFILEARN_BINDING);
            protocolMarshaller.marshall(instance.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(instance.lastServiceErrorId(), LASTSERVICEERRORID_BINDING);
            protocolMarshaller.marshall(instance.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall(instance.os(), OS_BINDING);
            protocolMarshaller.marshall(instance.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(instance.privateDns(), PRIVATEDNS_BINDING);
            protocolMarshaller.marshall(instance.privateIp(), PRIVATEIP_BINDING);
            protocolMarshaller.marshall(instance.publicDns(), PUBLICDNS_BINDING);
            protocolMarshaller.marshall(instance.publicIp(), PUBLICIP_BINDING);
            protocolMarshaller.marshall(instance.registeredBy(), REGISTEREDBY_BINDING);
            protocolMarshaller.marshall(instance.reportedAgentVersion(), REPORTEDAGENTVERSION_BINDING);
            protocolMarshaller.marshall(instance.reportedOs(), REPORTEDOS_BINDING);
            protocolMarshaller.marshall(instance.rootDeviceTypeAsString(), ROOTDEVICETYPE_BINDING);
            protocolMarshaller.marshall(instance.rootDeviceVolumeId(), ROOTDEVICEVOLUMEID_BINDING);
            protocolMarshaller.marshall(instance.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall(instance.sshHostDsaKeyFingerprint(), SSHHOSTDSAKEYFINGERPRINT_BINDING);
            protocolMarshaller.marshall(instance.sshHostRsaKeyFingerprint(), SSHHOSTRSAKEYFINGERPRINT_BINDING);
            protocolMarshaller.marshall(instance.sshKeyName(), SSHKEYNAME_BINDING);
            protocolMarshaller.marshall(instance.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall(instance.status(), STATUS_BINDING);
            protocolMarshaller.marshall(instance.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(instance.tenancy(), TENANCY_BINDING);
            protocolMarshaller.marshall(instance.virtualizationTypeAsString(), VIRTUALIZATIONTYPE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
