/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Layer JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LayerUnmarshaller implements Unmarshaller<Layer, JsonUnmarshallerContext> {

    public Layer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Layer.Builder layerBuilder = Layer.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    layerBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    layerBuilder.stackId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LayerId", targetDepth)) {
                    context.nextToken();
                    layerBuilder.layerId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    layerBuilder.type(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    layerBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Shortname", targetDepth)) {
                    context.nextToken();
                    layerBuilder.shortname(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    layerBuilder.attributesWithStrings(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CloudWatchLogsConfiguration", targetDepth)) {
                    context.nextToken();
                    layerBuilder.cloudWatchLogsConfiguration(CloudWatchLogsConfigurationUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("CustomInstanceProfileArn", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customInstanceProfileArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CustomJson", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customJson(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CustomSecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customSecurityGroupIds(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("DefaultSecurityGroupNames", targetDepth)) {
                    context.nextToken();
                    layerBuilder.defaultSecurityGroupNames(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("Packages", targetDepth)) {
                    context.nextToken();
                    layerBuilder
                            .packages(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("VolumeConfigurations", targetDepth)) {
                    context.nextToken();
                    layerBuilder.volumeConfigurations(new ListUnmarshaller<VolumeConfiguration>(VolumeConfigurationUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("EnableAutoHealing", targetDepth)) {
                    context.nextToken();
                    layerBuilder.enableAutoHealing(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoAssignElasticIps", targetDepth)) {
                    context.nextToken();
                    layerBuilder.autoAssignElasticIps(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("AutoAssignPublicIps", targetDepth)) {
                    context.nextToken();
                    layerBuilder.autoAssignPublicIps(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("DefaultRecipes", targetDepth)) {
                    context.nextToken();
                    layerBuilder.defaultRecipes(RecipesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CustomRecipes", targetDepth)) {
                    context.nextToken();
                    layerBuilder.customRecipes(RecipesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    layerBuilder.createdAt(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstallUpdatesOnBoot", targetDepth)) {
                    context.nextToken();
                    layerBuilder.installUpdatesOnBoot(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("UseEbsOptimizedInstances", targetDepth)) {
                    context.nextToken();
                    layerBuilder.useEbsOptimizedInstances(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("LifecycleEventConfiguration", targetDepth)) {
                    context.nextToken();
                    layerBuilder.lifecycleEventConfiguration(LifecycleEventConfigurationUnmarshaller.getInstance().unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return layerBuilder.build();
    }

    private static final LayerUnmarshaller INSTANCE = new LayerUnmarshaller();

    public static LayerUnmarshaller getInstance() {
        return INSTANCE;
    }
}
