/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstance;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RdsDbInstance} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RdsDbInstanceMarshaller {
    private static final MarshallingInfo<String> RDSDBINSTANCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RdsDbInstanceArn").isBinary(false).build();

    private static final MarshallingInfo<String> DBINSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbInstanceIdentifier").isBinary(false).build();

    private static final MarshallingInfo<String> DBUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbUser").isBinary(false).build();

    private static final MarshallingInfo<String> DBPASSWORD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbPassword").isBinary(false).build();

    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();

    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").isBinary(false).build();

    private static final MarshallingInfo<String> ENGINE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Engine").isBinary(false).build();

    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();

    private static final MarshallingInfo<Boolean> MISSINGONRDS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MissingOnRds").isBinary(false).build();

    private static final RdsDbInstanceMarshaller INSTANCE = new RdsDbInstanceMarshaller();

    private RdsDbInstanceMarshaller() {
    }

    public static RdsDbInstanceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RdsDbInstance rdsDbInstance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(rdsDbInstance, "rdsDbInstance");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(rdsDbInstance.rdsDbInstanceArn(), RDSDBINSTANCEARN_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.dbInstanceIdentifier(), DBINSTANCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.dbUser(), DBUSER_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.dbPassword(), DBPASSWORD_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.region(), REGION_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.engine(), ENGINE_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall(rdsDbInstance.missingOnRds(), MISSINGONRDS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
