/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Stack JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StackUnmarshaller implements Unmarshaller<Stack, JsonUnmarshallerContext> {

    public Stack unmarshall(JsonUnmarshallerContext context) throws Exception {
        Stack.Builder stackBuilder = Stack.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    stackBuilder.stackId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    stackBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Region", targetDepth)) {
                    context.nextToken();
                    stackBuilder.region(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    context.nextToken();
                    stackBuilder.vpcId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    stackBuilder.attributesWithStrings(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class),
                            context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ServiceRoleArn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.serviceRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DefaultInstanceProfileArn", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultInstanceProfileArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DefaultOs", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultOs(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HostnameTheme", targetDepth)) {
                    context.nextToken();
                    stackBuilder.hostnameTheme(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DefaultAvailabilityZone", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultAvailabilityZone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DefaultSubnetId", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultSubnetId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CustomJson", targetDepth)) {
                    context.nextToken();
                    stackBuilder.customJson(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ConfigurationManager", targetDepth)) {
                    context.nextToken();
                    stackBuilder.configurationManager(StackConfigurationManagerUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ChefConfiguration", targetDepth)) {
                    context.nextToken();
                    stackBuilder.chefConfiguration(ChefConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("UseCustomCookbooks", targetDepth)) {
                    context.nextToken();
                    stackBuilder.useCustomCookbooks(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("UseOpsworksSecurityGroups", targetDepth)) {
                    context.nextToken();
                    stackBuilder.useOpsworksSecurityGroups(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("CustomCookbooksSource", targetDepth)) {
                    context.nextToken();
                    stackBuilder.customCookbooksSource(SourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DefaultSshKeyName", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultSshKeyName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    stackBuilder.createdAt(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DefaultRootDeviceType", targetDepth)) {
                    context.nextToken();
                    stackBuilder.defaultRootDeviceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AgentVersion", targetDepth)) {
                    context.nextToken();
                    stackBuilder.agentVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return stackBuilder.build();
    }

    private static final StackUnmarshaller INSTANCE = new StackUnmarshaller();

    public static StackUnmarshaller getInstance() {
        return INSTANCE;
    }
}
