/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.UpdateLayerRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateLayerRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateLayerRequestModelMarshaller {
    private static final MarshallingInfo<String> LAYERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerId").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> SHORTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shortname").isBinary(false).build();

    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGSCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLogsConfiguration").isBinary(false).build();

    private static final MarshallingInfo<String> CUSTOMINSTANCEPROFILEARN_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CustomInstanceProfileArn").isBinary(false).build();

    private static final MarshallingInfo<String> CUSTOMJSON_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomJson").isBinary(false).build();

    private static final MarshallingInfo<List> CUSTOMSECURITYGROUPIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomSecurityGroupIds").isBinary(false).build();

    private static final MarshallingInfo<List> PACKAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Packages").isBinary(false).build();

    private static final MarshallingInfo<List> VOLUMECONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeConfigurations").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ENABLEAUTOHEALING_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableAutoHealing").isBinary(false).build();

    private static final MarshallingInfo<Boolean> AUTOASSIGNELASTICIPS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoAssignElasticIps").isBinary(false).build();

    private static final MarshallingInfo<Boolean> AUTOASSIGNPUBLICIPS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoAssignPublicIps").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CUSTOMRECIPES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomRecipes")
            .isBinary(false).build();

    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").isBinary(false).build();

    private static final MarshallingInfo<Boolean> USEEBSOPTIMIZEDINSTANCES_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("UseEbsOptimizedInstances").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LIFECYCLEEVENTCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LifecycleEventConfiguration").isBinary(false).build();

    private static final UpdateLayerRequestModelMarshaller INSTANCE = new UpdateLayerRequestModelMarshaller();

    private UpdateLayerRequestModelMarshaller() {
    }

    public static UpdateLayerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateLayerRequest updateLayerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateLayerRequest, "updateLayerRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateLayerRequest.layerId(), LAYERID_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.shortname(), SHORTNAME_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.attributesAsStrings(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.cloudWatchLogsConfiguration(), CLOUDWATCHLOGSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.customInstanceProfileArn(), CUSTOMINSTANCEPROFILEARN_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.customJson(), CUSTOMJSON_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.customSecurityGroupIds(), CUSTOMSECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.packages(), PACKAGES_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.volumeConfigurations(), VOLUMECONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.enableAutoHealing(), ENABLEAUTOHEALING_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.autoAssignElasticIps(), AUTOASSIGNELASTICIPS_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.autoAssignPublicIps(), AUTOASSIGNPUBLICIPS_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.customRecipes(), CUSTOMRECIPES_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.useEbsOptimizedInstances(), USEEBSOPTIMIZEDINSTANCES_BINDING);
            protocolMarshaller.marshall(updateLayerRequest.lifecycleEventConfiguration(), LIFECYCLEEVENTCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
