/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterRdsDbInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<RegisterRdsDbInstanceRequest.Builder, RegisterRdsDbInstanceRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterRdsDbInstanceRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> RDS_DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterRdsDbInstanceRequest::rdsDbInstanceArn)).setter(setter(Builder::rdsDbInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArn").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterRdsDbInstanceRequest::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterRdsDbInstanceRequest::dbPassword)).setter(setter(Builder::dbPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            RDS_DB_INSTANCE_ARN_FIELD, DB_USER_FIELD, DB_PASSWORD_FIELD));

    private final String stackId;

    private final String rdsDbInstanceArn;

    private final String dbUser;

    private final String dbPassword;

    private RegisterRdsDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The Amazon RDS instance's ARN.
     * </p>
     * 
     * @return The Amazon RDS instance's ARN.
     */
    public String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    /**
     * <p>
     * The database's master user name.
     * </p>
     * 
     * @return The database's master user name.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The database password.
     * </p>
     * 
     * @return The database password.
     */
    public String dbPassword() {
        return dbPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterRdsDbInstanceRequest)) {
            return false;
        }
        RegisterRdsDbInstanceRequest other = (RegisterRdsDbInstanceRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(rdsDbInstanceArn(), other.rdsDbInstanceArn())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(dbPassword(), other.dbPassword());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterRdsDbInstanceRequest").add("StackId", stackId())
                .add("RdsDbInstanceArn", rdsDbInstanceArn()).add("DbUser", dbUser()).add("DbPassword", dbPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "RdsDbInstanceArn":
            return Optional.ofNullable(clazz.cast(rdsDbInstanceArn()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "DbPassword":
            return Optional.ofNullable(clazz.cast(dbPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterRdsDbInstanceRequest, T> g) {
        return obj -> g.apply((RegisterRdsDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterRdsDbInstanceRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The Amazon RDS instance's ARN.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The Amazon RDS instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);

        /**
         * <p>
         * The database's master user name.
         * </p>
         * 
         * @param dbUser
         *        The database's master user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The database password.
         * </p>
         * 
         * @param dbPassword
         *        The database password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String rdsDbInstanceArn;

        private String dbUser;

        private String dbPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterRdsDbInstanceRequest model) {
            super(model);
            stackId(model.stackId);
            rdsDbInstanceArn(model.rdsDbInstanceArn);
            dbUser(model.dbUser);
            dbPassword(model.dbPassword);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterRdsDbInstanceRequest build() {
            return new RegisterRdsDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
