/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon EBS volume configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeConfiguration.Builder, VolumeConfiguration> {
    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeConfiguration::mountPoint)).setter(setter(Builder::mountPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoint").build()).build();

    private static final SdkField<Integer> RAID_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeConfiguration::raidLevel)).setter(setter(Builder::raidLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidLevel").build()).build();

    private static final SdkField<Integer> NUMBER_OF_DISKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeConfiguration::numberOfDisks)).setter(setter(Builder::numberOfDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDisks").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeConfiguration::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeConfiguration::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeConfiguration::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(VolumeConfiguration::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_POINT_FIELD,
            RAID_LEVEL_FIELD, NUMBER_OF_DISKS_FIELD, SIZE_FIELD, VOLUME_TYPE_FIELD, IOPS_FIELD, ENCRYPTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mountPoint;

    private final Integer raidLevel;

    private final Integer numberOfDisks;

    private final Integer size;

    private final String volumeType;

    private final Integer iops;

    private final Boolean encrypted;

    private VolumeConfiguration(BuilderImpl builder) {
        this.mountPoint = builder.mountPoint;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.encrypted = builder.encrypted;
    }

    /**
     * <p>
     * The volume mount point. For example "/dev/sdh".
     * </p>
     * 
     * @return The volume mount point. For example "/dev/sdh".
     */
    public String mountPoint() {
        return mountPoint;
    }

    /**
     * <p>
     * The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     * </p>
     * 
     * @return The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
     */
    public Integer raidLevel() {
        return raidLevel;
    }

    /**
     * <p>
     * The number of disks in the volume.
     * </p>
     * 
     * @return The number of disks in the volume.
     */
    public Integer numberOfDisks() {
        return numberOfDisks;
    }

    /**
     * <p>
     * The volume size.
     * </p>
     * 
     * @return The volume size.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The volume type. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume Types</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024
     * GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of
     * 16384 GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum
     * size of 16384 GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a
     * minimum size of 500 GiB and a maximum size of 16384 GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384
     * GiB.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The volume type. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume
     *         Types</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size
     *         of 1024 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum
     *         size of 16384 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a
     *         maximum size of 16384 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have
     *         a minimum size of 500 GiB and a maximum size of 16384 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of
     *         16384 GiB.
     *         </p>
     *         </li>
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * For PIOPS volumes, the IOPS per disk.
     * </p>
     * 
     * @return For PIOPS volumes, the IOPS per disk.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.
     * </p>
     * 
     * @return Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(raidLevel());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDisks());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration) obj;
        return Objects.equals(mountPoint(), other.mountPoint()) && Objects.equals(raidLevel(), other.raidLevel())
                && Objects.equals(numberOfDisks(), other.numberOfDisks()) && Objects.equals(size(), other.size())
                && Objects.equals(volumeType(), other.volumeType()) && Objects.equals(iops(), other.iops())
                && Objects.equals(encrypted(), other.encrypted());
    }

    @Override
    public String toString() {
        return ToString.builder("VolumeConfiguration").add("MountPoint", mountPoint()).add("RaidLevel", raidLevel())
                .add("NumberOfDisks", numberOfDisks()).add("Size", size()).add("VolumeType", volumeType()).add("Iops", iops())
                .add("Encrypted", encrypted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MountPoint":
            return Optional.ofNullable(clazz.cast(mountPoint()));
        case "RaidLevel":
            return Optional.ofNullable(clazz.cast(raidLevel()));
        case "NumberOfDisks":
            return Optional.ofNullable(clazz.cast(numberOfDisks()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeConfiguration, T> g) {
        return obj -> g.apply((VolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeConfiguration> {
        /**
         * <p>
         * The volume mount point. For example "/dev/sdh".
         * </p>
         * 
         * @param mountPoint
         *        The volume mount point. For example "/dev/sdh".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);

        /**
         * <p>
         * The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * </p>
         * 
         * @param raidLevel
         *        The volume <a href="http://en.wikipedia.org/wiki/Standard_RAID_levels">RAID level</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidLevel(Integer raidLevel);

        /**
         * <p>
         * The number of disks in the volume.
         * </p>
         * 
         * @param numberOfDisks
         *        The number of disks in the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDisks(Integer numberOfDisks);

        /**
         * <p>
         * The volume size.
         * </p>
         * 
         * @param size
         *        The volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The volume type. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume Types</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of
         * 1024 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size
         * of 16384 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a
         * maximum size of 16384 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a
         * minimum size of 500 GiB and a maximum size of 16384 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384
         * GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeType
         *        The volume type. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume
         *        Types</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum
         *        size of 1024 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a
         *        maximum size of 16384 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB
         *        and a maximum size of 16384 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must
         *        have a minimum size of 500 GiB and a maximum size of 16384 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size
         *        of 16384 GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * For PIOPS volumes, the IOPS per disk.
         * </p>
         * 
         * @param iops
         *        For PIOPS volumes, the IOPS per disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
         *        Encryption</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);
    }

    static final class BuilderImpl implements Builder {
        private String mountPoint;

        private Integer raidLevel;

        private Integer numberOfDisks;

        private Integer size;

        private String volumeType;

        private Integer iops;

        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            mountPoint(model.mountPoint);
            raidLevel(model.raidLevel);
            numberOfDisks(model.numberOfDisks);
            size(model.size);
            volumeType(model.volumeType);
            iops(model.iops);
            encrypted(model.encrypted);
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final Integer getRaidLevel() {
            return raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
