/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStackRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateStackRequest.Builder, CreateStackRequest> {
    private final String name;

    private final String region;

    private final String vpcId;

    private final Map<String, String> attributes;

    private final String serviceRoleArn;

    private final String defaultInstanceProfileArn;

    private final String defaultOs;

    private final String hostnameTheme;

    private final String defaultAvailabilityZone;

    private final String defaultSubnetId;

    private final String customJson;

    private final StackConfigurationManager configurationManager;

    private final ChefConfiguration chefConfiguration;

    private final Boolean useCustomCookbooks;

    private final Boolean useOpsworksSecurityGroups;

    private final Source customCookbooksSource;

    private final String defaultSshKeyName;

    private final String defaultRootDeviceType;

    private final String agentVersion;

    private CreateStackRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
        this.attributes = builder.attributes;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.defaultInstanceProfileArn = builder.defaultInstanceProfileArn;
        this.defaultOs = builder.defaultOs;
        this.hostnameTheme = builder.hostnameTheme;
        this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
        this.defaultSubnetId = builder.defaultSubnetId;
        this.customJson = builder.customJson;
        this.configurationManager = builder.configurationManager;
        this.chefConfiguration = builder.chefConfiguration;
        this.useCustomCookbooks = builder.useCustomCookbooks;
        this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
        this.customCookbooksSource = builder.customCookbooksSource;
        this.defaultSshKeyName = builder.defaultSshKeyName;
        this.defaultRootDeviceType = builder.defaultRootDeviceType;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The stack name.
     * </p>
     * 
     * @return The stack name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The stack's AWS region, such as "ap-south-1". For more information about Amazon regions, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The stack's AWS region, such as "ap-south-1". For more information about Amazon regions, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances are
     * launched into this VPC. You cannot change the ID later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your account supports EC2-Classic, the default value is <code>no VPC</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account does not support EC2-Classic, the default value is the default VPC for the specified region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code>
     * or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter.
     * If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone
     * for the specified region and the corresponding default VPC subnet ID, respectively.
     * </p>
     * <p>
     * If you specify a nondefault VPC ID, note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must belong to a VPC in your account that is in the specified region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify a value for <code>DefaultSubnetId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on how to use AWS OpsWorks Stacks with a VPC, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>.
     * For more information on default VPC and EC2-Classic, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>.
     * </p>
     * 
     * @return The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All
     *         instances are launched into this VPC. You cannot change the ID later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If your account supports EC2-Classic, the default value is <code>no VPC</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your account does not support EC2-Classic, the default value is the default VPC for the specified
     *         region.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the VPC ID corresponds to a default VPC and you have specified either the
     *         <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks
     *         Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks
     *         sets these parameters to the first valid Availability Zone for the specified region and the corresponding
     *         default VPC subnet ID, respectively.
     *         </p>
     *         <p>
     *         If you specify a nondefault VPC ID, note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must belong to a VPC in your account that is in the specified region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You must specify a value for <code>DefaultSubnetId</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on how to use AWS OpsWorks Stacks with a VPC, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a
     *         VPC</a>. For more information on default VPC and EC2-Classic, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         Platforms</a>.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key-value pairs to be added to the stack attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS
     * resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role.
     * For more information about IAM ARNs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with
     *         AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an
     *         existing IAM role. For more information about IAM ARNs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
     * instances. For more information about IAM ARNs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
     *         instances. For more information about IAM ARNs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String defaultInstanceProfileArn() {
        return defaultInstanceProfileArn;
    }

    /**
     * <p>
     * The stack's default operating system, which is installed on every instance unless you specify a different
     * operating system when you create the instance. You can specify one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>,
     * <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
     * <code>Amazon Linux 2015.03</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
     * <code>Ubuntu 12.04 LTS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CentOS Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Red Hat Enterprise Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more
     * information, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">
     * Using Custom AMIs</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default option is the current Amazon Linux version. For more information on the supported operating systems,
     * see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks
     * Operating Systems</a>.
     * </p>
     * 
     * @return The stack's default operating system, which is installed on every instance unless you specify a different
     *         operating system when you create the instance. You can specify one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>,
     *         <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>,
     *         or <code>Amazon Linux 2015.03</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>
     *         , or <code>Ubuntu 12.04 LTS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CentOS Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Red Hat Enterprise Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances.
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using
     *         Custom AMIs</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default option is the current Amazon Linux version. For more information on the supported operating
     *         systems, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS
     *         OpsWorks Stacks Operating Systems</a>.
     */
    public String defaultOs() {
        return defaultOs;
    }

    /**
     * <p>
     * The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names for
     * the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which
     * creates host names by appending integers to the layer's short name. The other themes are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Baked_Goods</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Clouds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Europe_Cities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fruits</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Greek_Deities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Legendary_creatures_from_Japan</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Planets_and_Moons</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Roman_Deities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Scottish_Islands</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>US_Cities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Wild_Cats</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the
     * current theme.
     * </p>
     * 
     * @return The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host
     *         names for the stack's instances. By default, <code>HostnameTheme</code> is set to
     *         <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name.
     *         The other themes are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Baked_Goods</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Clouds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Europe_Cities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fruits</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Greek_Deities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Legendary_creatures_from_Japan</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Planets_and_Moons</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Roman_Deities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Scottish_Islands</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>US_Cities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Wild_Cats</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based
     *         on the current theme.
     */
    public String hostnameTheme() {
        return hostnameTheme;
    }

    /**
     * <p>
     * The stack's default Availability Zone, which must be in the specified region. For more information, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a
     * value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the
     * <code>VpcId</code> parameter description.
     * </p>
     * 
     * @return The stack's default Availability Zone, which must be in the specified region. For more information, see
     *         <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also
     *         specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more
     *         information, see the <code>VpcId</code> parameter description.
     */
    public String defaultAvailabilityZone() {
        return defaultAvailabilityZone;
    }

    /**
     * <p>
     * The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code>
     * parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance.
     * If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For
     * information on default values and when this parameter is required, see the <code>VpcId</code> parameter
     * description.
     * </p>
     * 
     * @return The stack's default VPC subnet ID. This parameter is required if you specify a value for the
     *         <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise
     *         when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the
     *         subnet must be in that zone. For information on default values and when this parameter is required, see
     *         the <code>VpcId</code> parameter description.
     */
    public String defaultSubnetId() {
        return defaultSubnetId;
    }

    /**
     * <p>
     * A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack
     * configuration attribute values or to pass data to recipes. The string should be in the following format:
     * </p>
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * </p>
     * <p>
     * For more information on custom JSON, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the
     * Stack Configuration Attributes</a>.
     * </p>
     * 
     * @return A string that contains user-defined, custom JSON. It can be used to override the corresponding default
     *         stack configuration attribute values or to pass data to recipes. The string should be in the following
     *         format:</p>
     *         <p>
     *         <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     *         </p>
     *         <p>
     *         For more information on custom JSON, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
     *         Modify the Stack Configuration Attributes</a>.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * The configuration manager. When you create a stack we recommend that you use the configuration manager to specify
     * the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux
     * stacks is currently 11.4.
     * </p>
     * 
     * @return The configuration manager. When you create a stack we recommend that you use the configuration manager to
     *         specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default
     *         value for Linux stacks is currently 11.4.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    /**
     * <p>
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on
     * Chef 11.10 stacks. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.
     * </p>
     * 
     * @return A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
     *         version on Chef 11.10 stacks. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
     *         Stack</a>.
     */
    public ChefConfiguration chefConfiguration() {
        return chefConfiguration;
    }

    /**
     * <p>
     * Whether the stack uses custom cookbooks.
     * </p>
     * 
     * @return Whether the stack uses custom cookbooks.
     */
    public Boolean useCustomCookbooks() {
        return useCustomCookbooks;
    }

    /**
     * <p>
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     * </p>
     * <p>
     * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated
     * with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom
     * security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer
     * (default setting). You can associate additional security groups with a layer after you create it, but you cannot
     * delete the built-in security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate
     * EC2 security groups and associate a security group with each layer that you create. However, you can still
     * manually associate a built-in security group with a layer on creation; custom security groups are required only
     * for those layers that need custom settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.
     * </p>
     * 
     * @return Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
     *         <p>
     *         AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
     *         associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide
     *         your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each
     *         layer (default setting). You can associate additional security groups with a layer after you create it,
     *         but you cannot delete the built-in security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
     *         appropriate EC2 security groups and associate a security group with each layer that you create. However,
     *         you can still manually associate a built-in security group with a layer on creation; custom security
     *         groups are required only for those layers that need custom settings.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
     *         Stack</a>.
     */
    public Boolean useOpsworksSecurityGroups() {
        return useOpsworksSecurityGroups;
    }

    /**
     * Returns the value of the CustomCookbooksSource property for this object.
     * 
     * @return The value of the CustomCookbooksSource property for this object.
     */
    public Source customCookbooksSource() {
        return customCookbooksSource;
    }

    /**
     * <p>
     * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks
     * installs the public key on the instance and you can use the private key with an SSH client to log in to the
     * instance. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate
     * with an Instance</a> and <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html">
     * Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when
     * you <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
     * instance</a>.
     * </p>
     * 
     * @return A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS
     *         OpsWorks installs the public key on the instance and you can use the private key with an SSH client to
     *         log in to the instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
     *         Communicate with an Instance</a> and <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
     *         Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
     *         instance</a>.
     */
    public String defaultSshKeyName() {
        return defaultSshKeyName;
    }

    /**
     * <p>
     * The default root device type. This value is the default for all instances in the stack, but you can override it
     * when you create an instance. The default option is <code>instance-store</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage
     * for the Root Device</a>.
     * </p>
     * 
     * @return The default root device type. This value is the default for all instances in the stack, but you can
     *         override it when you create an instance. The default option is <code>instance-store</code>. For more
     *         information, see <a href=
     *         "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public String defaultRootDeviceType() {
        return defaultRootDeviceType;
    }

    /**
     * <p>
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent
     * versions on the stack's instances as soon as they are available.
     * </p>
     * </li>
     * <li>
     * <p>
     * Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit
     * the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version
     * on the stack's instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting is the most recent release of the agent. To specify an agent version, you must use the
     * complete version number, not the abbreviated number shown on the console. For a list of available agent version
     * numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     * </p>
     * <note>
     * <p>
     * You can also specify an agent version when you create or update an instance, which overrides the stack's default
     * setting.
     * </p>
     * </note>
     * 
     * @return The default AWS OpsWorks Stacks agent version. You have the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new
     *         agent versions on the stack's instances as soon as they are available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must
     *         edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs
     *         that version on the stack's instances.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting is the most recent release of the agent. To specify an agent version, you must use
     *         the complete version number, not the abbreviated number shown on the console. For a list of available
     *         agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     *         </p>
     *         <note>
     *         <p>
     *         You can also specify an agent version when you create or update an instance, which overrides the stack's
     *         default setting.
     *         </p>
     */
    public String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((region() == null) ? 0 : region().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        hashCode = 31 * hashCode + ((serviceRoleArn() == null) ? 0 : serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + ((defaultInstanceProfileArn() == null) ? 0 : defaultInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + ((defaultOs() == null) ? 0 : defaultOs().hashCode());
        hashCode = 31 * hashCode + ((hostnameTheme() == null) ? 0 : hostnameTheme().hashCode());
        hashCode = 31 * hashCode + ((defaultAvailabilityZone() == null) ? 0 : defaultAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + ((defaultSubnetId() == null) ? 0 : defaultSubnetId().hashCode());
        hashCode = 31 * hashCode + ((customJson() == null) ? 0 : customJson().hashCode());
        hashCode = 31 * hashCode + ((configurationManager() == null) ? 0 : configurationManager().hashCode());
        hashCode = 31 * hashCode + ((chefConfiguration() == null) ? 0 : chefConfiguration().hashCode());
        hashCode = 31 * hashCode + ((useCustomCookbooks() == null) ? 0 : useCustomCookbooks().hashCode());
        hashCode = 31 * hashCode + ((useOpsworksSecurityGroups() == null) ? 0 : useOpsworksSecurityGroups().hashCode());
        hashCode = 31 * hashCode + ((customCookbooksSource() == null) ? 0 : customCookbooksSource().hashCode());
        hashCode = 31 * hashCode + ((defaultSshKeyName() == null) ? 0 : defaultSshKeyName().hashCode());
        hashCode = 31 * hashCode + ((defaultRootDeviceType() == null) ? 0 : defaultRootDeviceType().hashCode());
        hashCode = 31 * hashCode + ((agentVersion() == null) ? 0 : agentVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.defaultInstanceProfileArn() == null ^ this.defaultInstanceProfileArn() == null) {
            return false;
        }
        if (other.defaultInstanceProfileArn() != null
                && !other.defaultInstanceProfileArn().equals(this.defaultInstanceProfileArn())) {
            return false;
        }
        if (other.defaultOs() == null ^ this.defaultOs() == null) {
            return false;
        }
        if (other.defaultOs() != null && !other.defaultOs().equals(this.defaultOs())) {
            return false;
        }
        if (other.hostnameTheme() == null ^ this.hostnameTheme() == null) {
            return false;
        }
        if (other.hostnameTheme() != null && !other.hostnameTheme().equals(this.hostnameTheme())) {
            return false;
        }
        if (other.defaultAvailabilityZone() == null ^ this.defaultAvailabilityZone() == null) {
            return false;
        }
        if (other.defaultAvailabilityZone() != null && !other.defaultAvailabilityZone().equals(this.defaultAvailabilityZone())) {
            return false;
        }
        if (other.defaultSubnetId() == null ^ this.defaultSubnetId() == null) {
            return false;
        }
        if (other.defaultSubnetId() != null && !other.defaultSubnetId().equals(this.defaultSubnetId())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        if (other.configurationManager() != null && !other.configurationManager().equals(this.configurationManager())) {
            return false;
        }
        if (other.chefConfiguration() == null ^ this.chefConfiguration() == null) {
            return false;
        }
        if (other.chefConfiguration() != null && !other.chefConfiguration().equals(this.chefConfiguration())) {
            return false;
        }
        if (other.useCustomCookbooks() == null ^ this.useCustomCookbooks() == null) {
            return false;
        }
        if (other.useCustomCookbooks() != null && !other.useCustomCookbooks().equals(this.useCustomCookbooks())) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() == null ^ this.useOpsworksSecurityGroups() == null) {
            return false;
        }
        if (other.useOpsworksSecurityGroups() != null
                && !other.useOpsworksSecurityGroups().equals(this.useOpsworksSecurityGroups())) {
            return false;
        }
        if (other.customCookbooksSource() == null ^ this.customCookbooksSource() == null) {
            return false;
        }
        if (other.customCookbooksSource() != null && !other.customCookbooksSource().equals(this.customCookbooksSource())) {
            return false;
        }
        if (other.defaultSshKeyName() == null ^ this.defaultSshKeyName() == null) {
            return false;
        }
        if (other.defaultSshKeyName() != null && !other.defaultSshKeyName().equals(this.defaultSshKeyName())) {
            return false;
        }
        if (other.defaultRootDeviceType() == null ^ this.defaultRootDeviceType() == null) {
            return false;
        }
        if (other.defaultRootDeviceType() != null && !other.defaultRootDeviceType().equals(this.defaultRootDeviceType())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (region() != null) {
            sb.append("Region: ").append(region()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(serviceRoleArn()).append(",");
        }
        if (defaultInstanceProfileArn() != null) {
            sb.append("DefaultInstanceProfileArn: ").append(defaultInstanceProfileArn()).append(",");
        }
        if (defaultOs() != null) {
            sb.append("DefaultOs: ").append(defaultOs()).append(",");
        }
        if (hostnameTheme() != null) {
            sb.append("HostnameTheme: ").append(hostnameTheme()).append(",");
        }
        if (defaultAvailabilityZone() != null) {
            sb.append("DefaultAvailabilityZone: ").append(defaultAvailabilityZone()).append(",");
        }
        if (defaultSubnetId() != null) {
            sb.append("DefaultSubnetId: ").append(defaultSubnetId()).append(",");
        }
        if (customJson() != null) {
            sb.append("CustomJson: ").append(customJson()).append(",");
        }
        if (configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(configurationManager()).append(",");
        }
        if (chefConfiguration() != null) {
            sb.append("ChefConfiguration: ").append(chefConfiguration()).append(",");
        }
        if (useCustomCookbooks() != null) {
            sb.append("UseCustomCookbooks: ").append(useCustomCookbooks()).append(",");
        }
        if (useOpsworksSecurityGroups() != null) {
            sb.append("UseOpsworksSecurityGroups: ").append(useOpsworksSecurityGroups()).append(",");
        }
        if (customCookbooksSource() != null) {
            sb.append("CustomCookbooksSource: ").append(customCookbooksSource()).append(",");
        }
        if (defaultSshKeyName() != null) {
            sb.append("DefaultSshKeyName: ").append(defaultSshKeyName()).append(",");
        }
        if (defaultRootDeviceType() != null) {
            sb.append("DefaultRootDeviceType: ").append(defaultRootDeviceType()).append(",");
        }
        if (agentVersion() != null) {
            sb.append("AgentVersion: ").append(agentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStackRequest> {
        /**
         * <p>
         * The stack name.
         * </p>
         * 
         * @param name
         *        The stack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The stack's AWS region, such as "ap-south-1". For more information about Amazon regions, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param region
         *        The stack's AWS region, such as "ap-south-1". For more information about Amazon regions, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All instances
         * are launched into this VPC. You cannot change the ID later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If your account supports EC2-Classic, the default value is <code>no VPC</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your account does not support EC2-Classic, the default value is the default VPC for the specified region.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the VPC ID corresponds to a default VPC and you have specified either the
         * <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks
         * infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these
         * parameters to the first valid Availability Zone for the specified region and the corresponding default VPC
         * subnet ID, respectively.
         * </p>
         * <p>
         * If you specify a nondefault VPC ID, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must belong to a VPC in your account that is in the specified region.
         * </p>
         * </li>
         * <li>
         * <p>
         * You must specify a value for <code>DefaultSubnetId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on how to use AWS OpsWorks Stacks with a VPC, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a
         * VPC</a>. For more information on default VPC and EC2-Classic, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a>.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC that the stack is to be launched into. The VPC must be in the stack's region. All
         *        instances are launched into this VPC. You cannot change the ID later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If your account supports EC2-Classic, the default value is <code>no VPC</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your account does not support EC2-Classic, the default value is the default VPC for the specified
         *        region.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the VPC ID corresponds to a default VPC and you have specified either the
         *        <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks
         *        Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks
         *        sets these parameters to the first valid Availability Zone for the specified region and the
         *        corresponding default VPC subnet ID, respectively.
         *        </p>
         *        <p>
         *        If you specify a nondefault VPC ID, note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must belong to a VPC in your account that is in the specified region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You must specify a value for <code>DefaultSubnetId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on how to use AWS OpsWorks Stacks with a VPC, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in
         *        a VPC</a>. For more information on default VPC and EC2-Classic, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key-value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS
         * resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM
         * role. For more information about IAM ARNs, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param serviceRoleArn
         *        The stack's AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work
         *        with AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for
         *        an existing IAM role. For more information about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
         * instances. For more information about IAM ARNs, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param defaultInstanceProfileArn
         *        The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's
         *        EC2 instances. For more information about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceProfileArn(String defaultInstanceProfileArn);

        /**
         * <p>
         * The stack's default operating system, which is installed on every instance unless you specify a different
         * operating system when you create the instance. You can specify one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>,
         * <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
         * <code>Amazon Linux 2015.03</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
         * <code>Ubuntu 12.04 LTS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CentOS Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Red Hat Enterprise Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using Custom
         * AMIs</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default option is the current Amazon Linux version. For more information on the supported operating
         * systems, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS
         * OpsWorks Stacks Operating Systems</a>.
         * </p>
         * 
         * @param defaultOs
         *        The stack's default operating system, which is installed on every instance unless you specify a
         *        different operating system when you create the instance. You can specify one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>,
         *        <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>,
         *        <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CentOS Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Red Hat Enterprise Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create
         *        instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"> Using
         *        Custom AMIs</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default option is the current Amazon Linux version. For more information on the supported
         *        operating systems, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks
         *        Stacks Operating Systems</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOs(String defaultOs);

        /**
         * <p>
         * The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host names
         * for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>,
         * which creates host names by appending integers to the layer's short name. The other themes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Baked_Goods</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Clouds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Europe_Cities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fruits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Greek_Deities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Legendary_creatures_from_Japan</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Planets_and_Moons</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Roman_Deities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Scottish_Islands</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>US_Cities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Wild_Cats</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on
         * the current theme.
         * </p>
         * 
         * @param hostnameTheme
         *        The stack's host name theme, with spaces replaced by underscores. The theme is used to generate host
         *        names for the stack's instances. By default, <code>HostnameTheme</code> is set to
         *        <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short
         *        name. The other themes are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Baked_Goods</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Clouds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Europe_Cities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fruits</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Greek_Deities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Legendary_creatures_from_Japan</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Planets_and_Moons</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Roman_Deities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Scottish_Islands</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>US_Cities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Wild_Cats</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name
         *        based on the current theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostnameTheme(String hostnameTheme);

        /**
         * <p>
         * The stack's default Availability Zone, which must be in the specified region. For more information, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify
         * a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the
         * <code>VpcId</code> parameter description.
         * </p>
         * 
         * @param defaultAvailabilityZone
         *        The stack's default Availability Zone, which must be in the specified region. For more information,
         *        see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If
         *        you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For
         *        more information, see the <code>VpcId</code> parameter description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAvailabilityZone(String defaultAvailabilityZone);

        /**
         * <p>
         * The stack's default VPC subnet ID. This parameter is required if you specify a value for the
         * <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when
         * you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet
         * must be in that zone. For information on default values and when this parameter is required, see the
         * <code>VpcId</code> parameter description.
         * </p>
         * 
         * @param defaultSubnetId
         *        The stack's default VPC subnet ID. This parameter is required if you specify a value for the
         *        <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise
         *        when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>,
         *        the subnet must be in that zone. For information on default values and when this parameter is
         *        required, see the <code>VpcId</code> parameter description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubnetId(String defaultSubnetId);

        /**
         * <p>
         * A string that contains user-defined, custom JSON. It can be used to override the corresponding default stack
         * configuration attribute values or to pass data to recipes. The string should be in the following format:
         * </p>
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * </p>
         * <p>
         * For more information on custom JSON, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify
         * the Stack Configuration Attributes</a>.
         * </p>
         * 
         * @param customJson
         *        A string that contains user-defined, custom JSON. It can be used to override the corresponding default
         *        stack configuration attribute values or to pass data to recipes. The string should be in the following
         *        format:</p>
         *        <p>
         *        <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *        </p>
         *        <p>
         *        For more information on custom JSON, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
         *        Modify the Stack Configuration Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * The configuration manager. When you create a stack we recommend that you use the configuration manager to
         * specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value
         * for Linux stacks is currently 11.4.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager. When you create a stack we recommend that you use the configuration manager
         *        to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The
         *        default value for Linux stacks is currently 11.4.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);

        /**
         * <p>
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version
         * on Chef 11.10 stacks. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * 
         * @param chefConfiguration
         *        A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
         *        version on Chef 11.10 stacks. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         *        Stack</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chefConfiguration(ChefConfiguration chefConfiguration);

        /**
         * <p>
         * Whether the stack uses custom cookbooks.
         * </p>
         * 
         * @param useCustomCookbooks
         *        Whether the stack uses custom cookbooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCustomCookbooks(Boolean useCustomCookbooks);

        /**
         * <p>
         * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         * </p>
         * <p>
         * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
         * associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your
         * own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer
         * (default setting). You can associate additional security groups with a layer after you create it, but you
         * cannot delete the built-in security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
         * appropriate EC2 security groups and associate a security group with each layer that you create. However, you
         * can still manually associate a built-in security group with a layer on creation; custom security groups are
         * required only for those layers that need custom settings.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * 
         * @param useOpsworksSecurityGroups
         *        Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
         *        <p>
         *        AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
         *        associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide
         *        your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each
         *        layer (default setting). You can associate additional security groups with a layer after you create
         *        it, but you cannot delete the built-in security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
         *        appropriate EC2 security groups and associate a security group with each layer that you create.
         *        However, you can still manually associate a built-in security group with a layer on creation; custom
         *        security groups are required only for those layers that need custom settings.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         *        Stack</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups);

        /**
         * Sets the value of the CustomCookbooksSource property for this object.
         *
         * @param customCookbooksSource
         *        The new value for the CustomCookbooksSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCookbooksSource(Source customCookbooksSource);

        /**
         * <p>
         * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks
         * installs the public key on the instance and you can use the private key with an SSH client to log in to the
         * instance. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
         * Communicate with an Instance</a> and <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
         * Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
         * instance</a>.
         * </p>
         * 
         * @param defaultSshKeyName
         *        A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS
         *        OpsWorks installs the public key on the instance and you can use the private key with an SSH client to
         *        log in to the instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
         *        Communicate with an Instance</a> and <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
         *        Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you
         *        <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
         *        instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSshKeyName(String defaultSshKeyName);

        /**
         * <p>
         * The default root device type. This value is the default for all instances in the stack, but you can override
         * it when you create an instance. The default option is <code>instance-store</code>. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">
         * Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is the default for all instances in the stack, but you can
         *        override it when you create an instance. The default option is <code>instance-store</code>. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(String defaultRootDeviceType);

        /**
         * <p>
         * The default root device type. This value is the default for all instances in the stack, but you can override
         * it when you create an instance. The default option is <code>instance-store</code>. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">
         * Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is the default for all instances in the stack, but you can
         *        override it when you create an instance. The default option is <code>instance-store</code>. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType);

        /**
         * <p>
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent
         * versions on the stack's instances as soon as they are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must
         * edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that
         * version on the stack's instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting is the most recent release of the agent. To specify an agent version, you must use the
         * complete version number, not the abbreviated number shown on the console. For a list of available agent
         * version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         * </p>
         * <note>
         * <p>
         * You can also specify an agent version when you create or update an instance, which overrides the stack's
         * default setting.
         * </p>
         * </note>
         * 
         * @param agentVersion
         *        The default AWS OpsWorks Stacks agent version. You have the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs
         *        new agent versions on the stack's instances as soon as they are available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Fixed version - Set this parameter to your preferred agent version. To update the agent version, you
         *        must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically
         *        installs that version on the stack's instances.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting is the most recent release of the agent. To specify an agent version, you must use
         *        the complete version number, not the abbreviated number shown on the console. For a list of available
         *        agent version numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         *        </p>
         *        <note>
         *        <p>
         *        You can also specify an agent version when you create or update an instance, which overrides the
         *        stack's default setting.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String region;

        private String vpcId;

        private Map<String, String> attributes;

        private String serviceRoleArn;

        private String defaultInstanceProfileArn;

        private String defaultOs;

        private String hostnameTheme;

        private String defaultAvailabilityZone;

        private String defaultSubnetId;

        private String customJson;

        private StackConfigurationManager configurationManager;

        private ChefConfiguration chefConfiguration;

        private Boolean useCustomCookbooks;

        private Boolean useOpsworksSecurityGroups;

        private Source customCookbooksSource;

        private String defaultSshKeyName;

        private String defaultRootDeviceType;

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            setName(model.name);
            setRegion(model.region);
            setVpcId(model.vpcId);
            setAttributes(model.attributes);
            setServiceRoleArn(model.serviceRoleArn);
            setDefaultInstanceProfileArn(model.defaultInstanceProfileArn);
            setDefaultOs(model.defaultOs);
            setHostnameTheme(model.hostnameTheme);
            setDefaultAvailabilityZone(model.defaultAvailabilityZone);
            setDefaultSubnetId(model.defaultSubnetId);
            setCustomJson(model.customJson);
            setConfigurationManager(model.configurationManager);
            setChefConfiguration(model.chefConfiguration);
            setUseCustomCookbooks(model.useCustomCookbooks);
            setUseOpsworksSecurityGroups(model.useOpsworksSecurityGroups);
            setCustomCookbooksSource(model.customCookbooksSource);
            setDefaultSshKeyName(model.defaultSshKeyName);
            setDefaultRootDeviceType(model.defaultRootDeviceType);
            setAgentVersion(model.agentVersion);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getDefaultInstanceProfileArn() {
            return defaultInstanceProfileArn;
        }

        @Override
        public final Builder defaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        public final void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        }

        public final String getDefaultOs() {
            return defaultOs;
        }

        @Override
        public final Builder defaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        public final void setDefaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
        }

        public final String getHostnameTheme() {
            return hostnameTheme;
        }

        @Override
        public final Builder hostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        public final void setHostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
        }

        public final String getDefaultAvailabilityZone() {
            return defaultAvailabilityZone;
        }

        @Override
        public final Builder defaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        public final void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
        }

        public final String getDefaultSubnetId() {
            return defaultSubnetId;
        }

        @Override
        public final Builder defaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        public final void setDefaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final StackConfigurationManager getConfigurationManager() {
            return configurationManager;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
        }

        public final ChefConfiguration getChefConfiguration() {
            return chefConfiguration;
        }

        @Override
        public final Builder chefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        public final void setChefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
        }

        public final Boolean getUseCustomCookbooks() {
            return useCustomCookbooks;
        }

        @Override
        public final Builder useCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        public final void setUseCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
        }

        public final Boolean getUseOpsworksSecurityGroups() {
            return useOpsworksSecurityGroups;
        }

        @Override
        public final Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        public final void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
        }

        public final Source getCustomCookbooksSource() {
            return customCookbooksSource;
        }

        @Override
        public final Builder customCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        public final void setCustomCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
        }

        public final String getDefaultSshKeyName() {
            return defaultSshKeyName;
        }

        @Override
        public final Builder defaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        public final void setDefaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
        }

        public final String getDefaultRootDeviceType() {
            return defaultRootDeviceType;
        }

        @Override
        public final Builder defaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        @Override
        public final Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
            return this;
        }

        public final void setDefaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
        }

        public final void setDefaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }
    }
}
