/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAppsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeAppsRequest.Builder, DescribeAppsRequest> {
    private final String stackId;

    private final List<String> appIds;

    private DescribeAppsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.appIds = builder.appIds;
    }

    /**
     * <p>
     * The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the
     * specified stack.
     * </p>
     * 
     * @return The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps
     *         in the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a
     * description of the specified apps. Otherwise, it returns a description of every app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
     *         returns a description of the specified apps. Otherwise, it returns a description of every app.
     */
    public List<String> appIds() {
        return appIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((appIds() == null) ? 0 : appIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsRequest)) {
            return false;
        }
        DescribeAppsRequest other = (DescribeAppsRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.appIds() == null ^ this.appIds() == null) {
            return false;
        }
        if (other.appIds() != null && !other.appIds().equals(this.appIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (appIds() != null) {
            sb.append("AppIds: ").append(appIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAppsRequest> {
        /**
         * <p>
         * The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in
         * the specified stack.
         * </p>
         * 
         * @param stackId
         *        The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the
         *        apps in the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         * returns a description of the specified apps. Otherwise, it returns a description of every app.
         * </p>
         * 
         * @param appIds
         *        An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         *        returns a description of the specified apps. Otherwise, it returns a description of every app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIds(Collection<String> appIds);

        /**
         * <p>
         * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         * returns a description of the specified apps. Otherwise, it returns a description of every app.
         * </p>
         * 
         * @param appIds
         *        An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         *        returns a description of the specified apps. Otherwise, it returns a description of every app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIds(String... appIds);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private List<String> appIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsRequest model) {
            setStackId(model.stackId);
            setAppIds(model.appIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getAppIds() {
            return appIds;
        }

        @Override
        public final Builder appIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appIds(String... appIds) {
            appIds(Arrays.asList(appIds));
            return this;
        }

        public final void setAppIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
        }

        @SafeVarargs
        public final void setAppIds(String... appIds) {
            appIds(Arrays.asList(appIds));
        }

        @Override
        public DescribeAppsRequest build() {
            return new DescribeAppsRequest(this);
        }
    }
}
