/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeElasticIpsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeElasticIpsRequest.Builder, DescribeElasticIpsRequest> {
    private final String instanceId;

    private final String stackId;

    private final List<String> ips;

    private DescribeElasticIpsRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.ips = builder.ips;
    }

    /**
     * <p>
     * The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
     * Elastic IP addresses associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of
     *         the Elastic IP addresses associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the Elastic
     * IP addresses that are registered with the specified stack.
     * </p>
     * 
     * @return A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
     *         Elastic IP addresses that are registered with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * An array of Elastic IP addresses to be described. If you include this parameter, <code>DescribeElasticIps</code>
     * returns a description of the specified Elastic IP addresses. Otherwise, it returns a description of every Elastic
     * IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of Elastic IP addresses to be described. If you include this parameter,
     *         <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise,
     *         it returns a description of every Elastic IP address.
     */
    public List<String> ips() {
        return ips;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((ips() == null) ? 0 : ips().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsRequest)) {
            return false;
        }
        DescribeElasticIpsRequest other = (DescribeElasticIpsRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.ips() == null ^ this.ips() == null) {
            return false;
        }
        if (other.ips() != null && !other.ips().equals(this.ips())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (ips() != null) {
            sb.append("Ips: ").append(ips()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeElasticIpsRequest> {
        /**
         * <p>
         * The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
         * Elastic IP addresses associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description
         *        of the Elastic IP addresses associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of the
         * Elastic IP addresses that are registered with the specified stack.
         * </p>
         * 
         * @param stackId
         *        A stack ID. If you include this parameter, <code>DescribeElasticIps</code> returns a description of
         *        the Elastic IP addresses that are registered with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of Elastic IP addresses to be described. If you include this parameter,
         * <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it
         * returns a description of every Elastic IP address.
         * </p>
         * 
         * @param ips
         *        An array of Elastic IP addresses to be described. If you include this parameter,
         *        <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses.
         *        Otherwise, it returns a description of every Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ips(Collection<String> ips);

        /**
         * <p>
         * An array of Elastic IP addresses to be described. If you include this parameter,
         * <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses. Otherwise, it
         * returns a description of every Elastic IP address.
         * </p>
         * 
         * @param ips
         *        An array of Elastic IP addresses to be described. If you include this parameter,
         *        <code>DescribeElasticIps</code> returns a description of the specified Elastic IP addresses.
         *        Otherwise, it returns a description of every Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ips(String... ips);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private String stackId;

        private List<String> ips;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsRequest model) {
            setInstanceId(model.instanceId);
            setStackId(model.stackId);
            setIps(model.ips);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getIps() {
            return ips;
        }

        @Override
        public final Builder ips(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ips(String... ips) {
            ips(Arrays.asList(ips));
            return this;
        }

        public final void setIps(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
        }

        @SafeVarargs
        public final void setIps(String... ips) {
            ips(Arrays.asList(ips));
        }

        @Override
        public DescribeElasticIpsRequest build() {
            return new DescribeElasticIpsRequest(this);
        }
    }
}
