/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStacks</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStacksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStacksResponse.Builder, DescribeStacksResponse> {
    private final List<Stack> stacks;

    private DescribeStacksResponse(BuilderImpl builder) {
        this.stacks = builder.stacks;
    }

    /**
     * <p>
     * An array of <code>Stack</code> objects that describe the stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Stack</code> objects that describe the stacks.
     */
    public List<Stack> stacks() {
        return stacks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stacks() == null) ? 0 : stacks().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse) obj;
        if (other.stacks() == null ^ this.stacks() == null) {
            return false;
        }
        if (other.stacks() != null && !other.stacks().equals(this.stacks())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stacks() != null) {
            sb.append("Stacks: ").append(stacks()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStacksResponse> {
        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * 
         * @param stacks
         *        An array of <code>Stack</code> objects that describe the stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Collection<Stack> stacks);

        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * 
         * @param stacks
         *        An array of <code>Stack</code> objects that describe the stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Stack... stacks);
    }

    private static final class BuilderImpl implements Builder {
        private List<Stack> stacks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            setStacks(model.stacks);
        }

        public final Collection<Stack> getStacks() {
            return stacks;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack... stacks) {
            stacks(Arrays.asList(stacks));
            return this;
        }

        public final void setStacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
        }

        @SafeVarargs
        public final void setStacks(Stack... stacks) {
            stacks(Arrays.asList(stacks));
        }

        @Override
        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }
    }
}
