/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.InstanceIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a description of an Amazon EC2 instance from the Amazon EC2 metadata service. For more information, see <a
 * href="http://docs.aws.amazon.com/sdkfornet/latest/apidocs/Index.html">Instance Metadata and User Data</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceIdentity implements StructuredPojo, ToCopyableBuilder<InstanceIdentity.Builder, InstanceIdentity> {
    private final String document;

    private final String signature;

    private InstanceIdentity(BuilderImpl builder) {
        this.document = builder.document;
        this.signature = builder.signature;
    }

    /**
     * <p>
     * A JSON document that contains the metadata.
     * </p>
     * 
     * @return A JSON document that contains the metadata.
     */
    public String document() {
        return document;
    }

    /**
     * <p>
     * A signature that can be used to verify the document's accuracy and authenticity.
     * </p>
     * 
     * @return A signature that can be used to verify the document's accuracy and authenticity.
     */
    public String signature() {
        return signature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((document() == null) ? 0 : document().hashCode());
        hashCode = 31 * hashCode + ((signature() == null) ? 0 : signature().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceIdentity)) {
            return false;
        }
        InstanceIdentity other = (InstanceIdentity) obj;
        if (other.document() == null ^ this.document() == null) {
            return false;
        }
        if (other.document() != null && !other.document().equals(this.document())) {
            return false;
        }
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        if (other.signature() != null && !other.signature().equals(this.signature())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (document() != null) {
            sb.append("Document: ").append(document()).append(",");
        }
        if (signature() != null) {
            sb.append("Signature: ").append(signature()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceIdentity> {
        /**
         * <p>
         * A JSON document that contains the metadata.
         * </p>
         * 
         * @param document
         *        A JSON document that contains the metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);

        /**
         * <p>
         * A signature that can be used to verify the document's accuracy and authenticity.
         * </p>
         * 
         * @param signature
         *        A signature that can be used to verify the document's accuracy and authenticity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);
    }

    private static final class BuilderImpl implements Builder {
        private String document;

        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceIdentity model) {
            setDocument(model.document);
            setSignature(model.signature);
        }

        public final String getDocument() {
            return document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public InstanceIdentity build() {
            return new InstanceIdentity(this);
        }
    }
}
