/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTagsRequest.Builder, ListTagsRequest> {
    private final String resourceArn;

    private final Integer maxResults;

    private final String nextToken;

    private ListTagsRequest(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The stack or layer's Amazon Resource Number (ARN).
     * </p>
     * 
     * @return The stack or layer's Amazon Resource Number (ARN).
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a
     * <code>ListTagsRequest</code> call.
     * </p>
     * 
     * @return Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a
     *         <code>ListTagsRequest</code> call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a
     * <code>ListTagsRequest</code> call.
     * </p>
     * 
     * @return Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a
     *         <code>ListTagsRequest</code> call.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceArn() == null) ? 0 : resourceArn().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsRequest)) {
            return false;
        }
        ListTagsRequest other = (ListTagsRequest) obj;
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceArn() != null) {
            sb.append("ResourceArn: ").append(resourceArn()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsRequest> {
        /**
         * <p>
         * The stack or layer's Amazon Resource Number (ARN).
         * </p>
         * 
         * @param resourceArn
         *        The stack or layer's Amazon Resource Number (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a
         * <code>ListTagsRequest</code> call.
         * </p>
         * 
         * @param maxResults
         *        Do not use. A validation exception occurs if you add a <code>MaxResults</code> parameter to a
         *        <code>ListTagsRequest</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a
         * <code>ListTagsRequest</code> call.
         * </p>
         * 
         * @param nextToken
         *        Do not use. A validation exception occurs if you add a <code>NextToken</code> parameter to a
         *        <code>ListTagsRequest</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceArn;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsRequest model) {
            setResourceArn(model.resourceArn);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTagsRequest build() {
            return new ListTagsRequest(this);
        }
    }
}
