/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SetLoadBasedAutoScalingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetLoadBasedAutoScalingRequest.Builder, SetLoadBasedAutoScalingRequest> {
    private final String layerId;

    private final Boolean enable;

    private final AutoScalingThresholds upScaling;

    private final AutoScalingThresholds downScaling;

    private SetLoadBasedAutoScalingRequest(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.enable = builder.enable;
        this.upScaling = builder.upScaling;
        this.downScaling = builder.downScaling;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * Enables load-based auto scaling for the layer.
     * </p>
     * 
     * @return Enables load-based auto scaling for the layer.
     */
    public Boolean enable() {
        return enable;
    }

    /**
     * <p>
     * An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds
     * these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.
     * </p>
     * 
     * @return An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load
     *         exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of
     *         instances.
     */
    public AutoScalingThresholds upScaling() {
        return upScaling;
    }

    /**
     * <p>
     * An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls
     * below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of instances.
     * </p>
     * 
     * @return An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load
     *         falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number
     *         of instances.
     */
    public AutoScalingThresholds downScaling() {
        return downScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((layerId() == null) ? 0 : layerId().hashCode());
        hashCode = 31 * hashCode + ((enable() == null) ? 0 : enable().hashCode());
        hashCode = 31 * hashCode + ((upScaling() == null) ? 0 : upScaling().hashCode());
        hashCode = 31 * hashCode + ((downScaling() == null) ? 0 : downScaling().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBasedAutoScalingRequest)) {
            return false;
        }
        SetLoadBasedAutoScalingRequest other = (SetLoadBasedAutoScalingRequest) obj;
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        if (other.enable() == null ^ this.enable() == null) {
            return false;
        }
        if (other.enable() != null && !other.enable().equals(this.enable())) {
            return false;
        }
        if (other.upScaling() == null ^ this.upScaling() == null) {
            return false;
        }
        if (other.upScaling() != null && !other.upScaling().equals(this.upScaling())) {
            return false;
        }
        if (other.downScaling() == null ^ this.downScaling() == null) {
            return false;
        }
        if (other.downScaling() != null && !other.downScaling().equals(this.downScaling())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (layerId() != null) {
            sb.append("LayerId: ").append(layerId()).append(",");
        }
        if (enable() != null) {
            sb.append("Enable: ").append(enable()).append(",");
        }
        if (upScaling() != null) {
            sb.append("UpScaling: ").append(upScaling()).append(",");
        }
        if (downScaling() != null) {
            sb.append("DownScaling: ").append(downScaling()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetLoadBasedAutoScalingRequest> {
        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * Enables load-based auto scaling for the layer.
         * </p>
         * 
         * @param enable
         *        Enables load-based auto scaling for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds
         * these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.
         * </p>
         * 
         * @param upScaling
         *        An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load
         *        exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number
         *        of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upScaling(AutoScalingThresholds upScaling);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls
         * below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of
         * instances.
         * </p>
         * 
         * @param downScaling
         *        An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load
         *        falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified
         *        number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downScaling(AutoScalingThresholds downScaling);
    }

    private static final class BuilderImpl implements Builder {
        private String layerId;

        private Boolean enable;

        private AutoScalingThresholds upScaling;

        private AutoScalingThresholds downScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBasedAutoScalingRequest model) {
            setLayerId(model.layerId);
            setEnable(model.enable);
            setUpScaling(model.upScaling);
            setDownScaling(model.downScaling);
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Boolean getEnable() {
            return enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final AutoScalingThresholds getUpScaling() {
            return upScaling;
        }

        @Override
        public final Builder upScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
            return this;
        }

        public final void setUpScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
        }

        public final AutoScalingThresholds getDownScaling() {
            return downScaling;
        }

        @Override
        public final Builder downScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
            return this;
        }

        public final void setDownScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
        }

        @Override
        public SetLoadBasedAutoScalingRequest build() {
            return new SetLoadBasedAutoScalingRequest(this);
        }
    }
}
