/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ShutdownEventConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Shutdown event configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ShutdownEventConfiguration implements StructuredPojo,
        ToCopyableBuilder<ShutdownEventConfiguration.Builder, ShutdownEventConfiguration> {
    private final Integer executionTimeout;

    private final Boolean delayUntilElbConnectionsDrained;

    private ShutdownEventConfiguration(BuilderImpl builder) {
        this.executionTimeout = builder.executionTimeout;
        this.delayUntilElbConnectionsDrained = builder.delayUntilElbConnectionsDrained;
    }

    /**
     * <p>
     * The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting down
     * an instance.
     * </p>
     * 
     * @return The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before
     *         shutting down an instance.
     */
    public Integer executionTimeout() {
        return executionTimeout;
    }

    /**
     * <p>
     * Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
     * "http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
     * >Connection Draining</a>
     * </p>
     * 
     * @return Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
     *         "http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
     *         >Connection Draining</a>
     */
    public Boolean delayUntilElbConnectionsDrained() {
        return delayUntilElbConnectionsDrained;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((executionTimeout() == null) ? 0 : executionTimeout().hashCode());
        hashCode = 31 * hashCode
                + ((delayUntilElbConnectionsDrained() == null) ? 0 : delayUntilElbConnectionsDrained().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShutdownEventConfiguration)) {
            return false;
        }
        ShutdownEventConfiguration other = (ShutdownEventConfiguration) obj;
        if (other.executionTimeout() == null ^ this.executionTimeout() == null) {
            return false;
        }
        if (other.executionTimeout() != null && !other.executionTimeout().equals(this.executionTimeout())) {
            return false;
        }
        if (other.delayUntilElbConnectionsDrained() == null ^ this.delayUntilElbConnectionsDrained() == null) {
            return false;
        }
        if (other.delayUntilElbConnectionsDrained() != null
                && !other.delayUntilElbConnectionsDrained().equals(this.delayUntilElbConnectionsDrained())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (executionTimeout() != null) {
            sb.append("ExecutionTimeout: ").append(executionTimeout()).append(",");
        }
        if (delayUntilElbConnectionsDrained() != null) {
            sb.append("DelayUntilElbConnectionsDrained: ").append(delayUntilElbConnectionsDrained()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShutdownEventConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ShutdownEventConfiguration> {
        /**
         * <p>
         * The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before shutting
         * down an instance.
         * </p>
         * 
         * @param executionTimeout
         *        The time, in seconds, that AWS OpsWorks Stacks will wait after triggering a Shutdown event before
         *        shutting down an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeout(Integer executionTimeout);

        /**
         * <p>
         * Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
         * "http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
         * >Connection Draining</a>
         * </p>
         * 
         * @param delayUntilElbConnectionsDrained
         *        Whether to enable Elastic Load Balancing connection draining. For more information, see <a href=
         *        "http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain"
         *        >Connection Draining</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained);
    }

    private static final class BuilderImpl implements Builder {
        private Integer executionTimeout;

        private Boolean delayUntilElbConnectionsDrained;

        private BuilderImpl() {
        }

        private BuilderImpl(ShutdownEventConfiguration model) {
            setExecutionTimeout(model.executionTimeout);
            setDelayUntilElbConnectionsDrained(model.delayUntilElbConnectionsDrained);
        }

        public final Integer getExecutionTimeout() {
            return executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        public final Boolean getDelayUntilElbConnectionsDrained() {
            return delayUntilElbConnectionsDrained;
        }

        @Override
        public final Builder delayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
            return this;
        }

        public final void setDelayUntilElbConnectionsDrained(Boolean delayUntilElbConnectionsDrained) {
            this.delayUntilElbConnectionsDrained = delayUntilElbConnectionsDrained;
        }

        @Override
        public ShutdownEventConfiguration build() {
            return new ShutdownEventConfiguration(this);
        }
    }
}
