/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateAppRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateAppRequest.Builder, UpdateAppRequest> {
    private final String appId;

    private final String name;

    private final String description;

    private final List<DataSource> dataSources;

    private final String type;

    private final Source appSource;

    private final List<String> domains;

    private final Boolean enableSsl;

    private final SslConfiguration sslConfiguration;

    private final Map<String, String> attributes;

    private final List<EnvironmentVariable> environment;

    private UpdateAppRequest(BuilderImpl builder) {
        this.appId = builder.appId;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSources = builder.dataSources;
        this.type = builder.type;
        this.appSource = builder.appSource;
        this.domains = builder.domains;
        this.enableSsl = builder.enableSsl;
        this.sslConfiguration = builder.sslConfiguration;
        this.attributes = builder.attributes;
        this.environment = builder.environment;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * The app name.
     * </p>
     * 
     * @return The app name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the app.
     * </p>
     * 
     * @return A description of the app.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The app's data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app's data sources.
     */
    public List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * The app type.
     * </p>
     * 
     * @return The app type.
     * @see AppType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * A <code>Source</code> object that specifies the app repository.
     * </p>
     * 
     * @return A <code>Source</code> object that specifies the app repository.
     */
    public Source appSource() {
        return appSource;
    }

    /**
     * <p>
     * The app's virtual host settings, with multiple domains separated by commas. For example:
     * <code>'www.example.com, example.com'</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app's virtual host settings, with multiple domains separated by commas. For example:
     *         <code>'www.example.com, example.com'</code>
     */
    public List<String> domains() {
        return domains;
    }

    /**
     * <p>
     * Whether SSL is enabled for the app.
     * </p>
     * 
     * @return Whether SSL is enabled for the app.
     */
    public Boolean enableSsl() {
        return enableSsl;
    }

    /**
     * <p>
     * An <code>SslConfiguration</code> object with the SSL configuration.
     * </p>
     * 
     * @return An <code>SslConfiguration</code> object with the SSL configuration.
     */
    public SslConfiguration sslConfiguration() {
        return sslConfiguration;
    }

    /**
     * <p>
     * One or more user-defined key/value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key/value pairs to be added to the stack attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the
     * app. After you deploy the app, these variables are defined on the associated app server instances.For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     * > Environment Variables</a>.
     * </p>
     * <p>
     * There is no specific limit on the number of environment variables. However, the size of the associated data
     * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB (10240
     * Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the
     * message, "Environment: is too large (maximum is 10KB)."
     * </p>
     * <note>
     * <p>
     * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment variables,
     * you cannot modify the stack's Chef version.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated
     *         with the app. After you deploy the app, these variables are defined on the associated app server
     *         instances.For more information, see <a href=
     *         "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     *         > Environment Variables</a>.</p>
     *         <p>
     *         There is no specific limit on the number of environment variables. However, the size of the associated
     *         data structure - which includes the variables' names, values, and protected flag values - cannot exceed
     *         10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an
     *         exception with the message, "Environment: is too large (maximum is 10KB)."
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
     *         variables, you cannot modify the stack's Chef version.
     *         </p>
     */
    public List<EnvironmentVariable> environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((appId() == null) ? 0 : appId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((dataSources() == null) ? 0 : dataSources().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((appSource() == null) ? 0 : appSource().hashCode());
        hashCode = 31 * hashCode + ((domains() == null) ? 0 : domains().hashCode());
        hashCode = 31 * hashCode + ((enableSsl() == null) ? 0 : enableSsl().hashCode());
        hashCode = 31 * hashCode + ((sslConfiguration() == null) ? 0 : sslConfiguration().hashCode());
        hashCode = 31 * hashCode + ((attributes() == null) ? 0 : attributes().hashCode());
        hashCode = 31 * hashCode + ((environment() == null) ? 0 : environment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest) obj;
        if (other.appId() == null ^ this.appId() == null) {
            return false;
        }
        if (other.appId() != null && !other.appId().equals(this.appId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.dataSources() == null ^ this.dataSources() == null) {
            return false;
        }
        if (other.dataSources() != null && !other.dataSources().equals(this.dataSources())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.appSource() == null ^ this.appSource() == null) {
            return false;
        }
        if (other.appSource() != null && !other.appSource().equals(this.appSource())) {
            return false;
        }
        if (other.domains() == null ^ this.domains() == null) {
            return false;
        }
        if (other.domains() != null && !other.domains().equals(this.domains())) {
            return false;
        }
        if (other.enableSsl() == null ^ this.enableSsl() == null) {
            return false;
        }
        if (other.enableSsl() != null && !other.enableSsl().equals(this.enableSsl())) {
            return false;
        }
        if (other.sslConfiguration() == null ^ this.sslConfiguration() == null) {
            return false;
        }
        if (other.sslConfiguration() != null && !other.sslConfiguration().equals(this.sslConfiguration())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (appId() != null) {
            sb.append("AppId: ").append(appId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (dataSources() != null) {
            sb.append("DataSources: ").append(dataSources()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (appSource() != null) {
            sb.append("AppSource: ").append(appSource()).append(",");
        }
        if (domains() != null) {
            sb.append("Domains: ").append(domains()).append(",");
        }
        if (enableSsl() != null) {
            sb.append("EnableSsl: ").append(enableSsl()).append(",");
        }
        if (sslConfiguration() != null) {
            sb.append("SslConfiguration: ").append(sslConfiguration()).append(",");
        }
        if (attributes() != null) {
            sb.append("Attributes: ").append(attributes()).append(",");
        }
        if (environment() != null) {
            sb.append("Environment: ").append(environment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateAppRequest> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The app name.
         * </p>
         * 
         * @param name
         *        The app name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the app.
         * </p>
         * 
         * @param description
         *        A description of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The app's data sources.
         * </p>
         * 
         * @param dataSources
         *        The app's data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The app's data sources.
         * </p>
         * 
         * @param dataSources
         *        The app's data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The app type.
         * </p>
         * 
         * @param type
         *        The app type.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(String type);

        /**
         * <p>
         * The app type.
         * </p>
         * 
         * @param type
         *        The app type.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(AppType type);

        /**
         * <p>
         * A <code>Source</code> object that specifies the app repository.
         * </p>
         * 
         * @param appSource
         *        A <code>Source</code> object that specifies the app repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSource(Source appSource);

        /**
         * <p>
         * The app's virtual host settings, with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app's virtual host settings, with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<String> domains);

        /**
         * <p>
         * The app's virtual host settings, with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app's virtual host settings, with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(String... domains);

        /**
         * <p>
         * Whether SSL is enabled for the app.
         * </p>
         * 
         * @param enableSsl
         *        Whether SSL is enabled for the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSsl(Boolean enableSsl);

        /**
         * <p>
         * An <code>SslConfiguration</code> object with the SSL configuration.
         * </p>
         * 
         * @param sslConfiguration
         *        An <code>SslConfiguration</code> object with the SSL configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslConfiguration(SslConfiguration sslConfiguration);

        /**
         * <p>
         * One or more user-defined key/value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key/value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instances.For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB
         * (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception
         * with the message, "Environment: is too large (maximum is 10KB)."
         * </p>
         * <note>
         * <p>
         * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         * variables, you cannot modify the stack's Chef version.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instances.For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>.</p>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variables' names, values, and protected flag values - cannot
         *        exceed 10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will
         *        cause an exception with the message, "Environment: is too large (maximum is 10KB)."
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         *        variables, you cannot modify the stack's Chef version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<EnvironmentVariable> environment);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instances.For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB
         * (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception
         * with the message, "Environment: is too large (maximum is 10KB)."
         * </p>
         * <note>
         * <p>
         * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         * variables, you cannot modify the stack's Chef version.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instances.For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>.</p>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variables' names, values, and protected flag values - cannot
         *        exceed 10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will
         *        cause an exception with the message, "Environment: is too large (maximum is 10KB)."
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         *        variables, you cannot modify the stack's Chef version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EnvironmentVariable... environment);
    }

    private static final class BuilderImpl implements Builder {
        private String appId;

        private String name;

        private String description;

        private List<DataSource> dataSources;

        private String type;

        private Source appSource;

        private List<String> domains;

        private Boolean enableSsl;

        private SslConfiguration sslConfiguration;

        private Map<String, String> attributes;

        private List<EnvironmentVariable> environment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppRequest model) {
            setAppId(model.appId);
            setName(model.name);
            setDescription(model.description);
            setDataSources(model.dataSources);
            setType(model.type);
            setAppSource(model.appSource);
            setDomains(model.domains);
            setEnableSsl(model.enableSsl);
            setSslConfiguration(model.sslConfiguration);
            setAttributes(model.attributes);
            setEnvironment(model.environment);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DataSource> getDataSources() {
            return dataSources;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final void setDataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
        }

        @SafeVarargs
        public final void setDataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(AppType type) {
            this.type(type.toString());
        }

        public final Source getAppSource() {
            return appSource;
        }

        @Override
        public final Builder appSource(Source appSource) {
            this.appSource = appSource;
            return this;
        }

        public final void setAppSource(Source appSource) {
            this.appSource = appSource;
        }

        public final Collection<String> getDomains() {
            return domains;
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
        }

        @SafeVarargs
        public final void setDomains(String... domains) {
            domains(Arrays.asList(domains));
        }

        public final Boolean getEnableSsl() {
            return enableSsl;
        }

        @Override
        public final Builder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public final void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public final SslConfiguration getSslConfiguration() {
            return sslConfiguration;
        }

        @Override
        public final Builder sslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public final void setSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
        }

        public final Collection<EnvironmentVariable> getEnvironment() {
            return environment;
        }

        @Override
        public final Builder environment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EnvironmentVariable... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
        }

        @SafeVarargs
        public final void setEnvironment(EnvironmentVariable... environment) {
            environment(Arrays.asList(environment));
        }

        @Override
        public UpdateAppRequest build() {
            return new UpdateAppRequest(this);
        }
    }
}
