/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.opsworks.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * RdsDbInstanceMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class RdsDbInstanceMarshaller {

    private static final MarshallingInfo<String> RDSDBINSTANCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RdsDbInstanceArn").build();
    private static final MarshallingInfo<String> DBINSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbInstanceIdentifier").build();
    private static final MarshallingInfo<String> DBUSER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbUser").build();
    private static final MarshallingInfo<String> DBPASSWORD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DbPassword").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").build();
    private static final MarshallingInfo<String> ENGINE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Engine").build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<Boolean> MISSINGONRDS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MissingOnRds").build();

    private static final RdsDbInstanceMarshaller instance = new RdsDbInstanceMarshaller();

    public static RdsDbInstanceMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RdsDbInstance rdsDbInstance, ProtocolMarshaller protocolMarshaller) {

        if (rdsDbInstance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(rdsDbInstance.rdsDbInstanceArn(), RDSDBINSTANCEARN_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.dbInstanceIdentifier(), DBINSTANCEIDENTIFIER_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.dbUser(), DBUSER_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.dbPassword(), DBPASSWORD_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.region(), REGION_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.address(), ADDRESS_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.engine(), ENGINE_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.stackId(), STACKID_BINDING);

            protocolMarshaller.marshall(rdsDbInstance.missingOnRds(), MISSINGONRDS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
