/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.services.opsworks.transform.AgentVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AgentVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, AgentVersion> {
    private final String version;
    private final StackConfigurationManager configurationManager;

    private AgentVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.configurationManager = builder.configurationManager;
    }

    public String version() {
        return this.version;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.configurationManager() == null ? 0 : this.configurationManager().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersion)) {
            return false;
        }
        AgentVersion other = (AgentVersion)obj;
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        return other.configurationManager() == null || other.configurationManager().equals(this.configurationManager());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(this.configurationManager()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgentVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String version;
        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersion model) {
            this.setVersion(model.version);
            this.setConfigurationManager(model.configurationManager);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final StackConfigurationManager getConfigurationManager() {
            return this.configurationManager;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
        }

        public AgentVersion build() {
            return new AgentVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AgentVersion> {
        public Builder version(String var1);

        public Builder configurationManager(StackConfigurationManager var1);
    }
}

