/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum Architecture {
    X86_64("x86_64"),
    I386("i386");

    private final String value;

    private Architecture(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static Architecture fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(Architecture.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

