/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstance;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstancesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRdsDbInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeRdsDbInstancesResponse> {
    private final List<RdsDbInstance> rdsDbInstances;

    private DescribeRdsDbInstancesResponse(BuilderImpl builder) {
        this.rdsDbInstances = builder.rdsDbInstances;
    }

    public List<RdsDbInstance> rdsDbInstances() {
        return this.rdsDbInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rdsDbInstances() == null ? 0 : this.rdsDbInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesResponse)) {
            return false;
        }
        DescribeRdsDbInstancesResponse other = (DescribeRdsDbInstancesResponse)((Object)obj);
        if (other.rdsDbInstances() == null ^ this.rdsDbInstances() == null) {
            return false;
        }
        return other.rdsDbInstances() == null || other.rdsDbInstances().equals(this.rdsDbInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rdsDbInstances() != null) {
            sb.append("RdsDbInstances: ").append(this.rdsDbInstances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<RdsDbInstance> rdsDbInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesResponse model) {
            this.setRdsDbInstances(model.rdsDbInstances);
        }

        public final Collection<RdsDbInstance> getRdsDbInstances() {
            return this.rdsDbInstances;
        }

        @Override
        public final Builder rdsDbInstances(Collection<RdsDbInstance> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copy(rdsDbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstances(RdsDbInstance ... rdsDbInstances) {
            this.rdsDbInstances(Arrays.asList(rdsDbInstances));
            return this;
        }

        public final void setRdsDbInstances(Collection<RdsDbInstance> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copy(rdsDbInstances);
        }

        @SafeVarargs
        public final void setRdsDbInstances(RdsDbInstance ... rdsDbInstances) {
            this.rdsDbInstances(Arrays.asList(rdsDbInstances));
        }

        public DescribeRdsDbInstancesResponse build() {
            return new DescribeRdsDbInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRdsDbInstancesResponse> {
        public Builder rdsDbInstances(Collection<RdsDbInstance> var1);

        public Builder rdsDbInstances(RdsDbInstance ... var1);
    }
}

