/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum LayerType {
    AwsFlowRuby("aws-flow-ruby"),
    EcsCluster("ecs-cluster"),
    JavaApp("java-app"),
    Lb("lb"),
    Web("web"),
    PhpApp("php-app"),
    RailsApp("rails-app"),
    NodejsApp("nodejs-app"),
    Memcached("memcached"),
    DbMaster("db-master"),
    MonitoringMaster("monitoring-master"),
    Custom("custom");

    private final String value;

    private LayerType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static LayerType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(LayerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

