/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.AutoScalingThresholds;
import software.amazon.awssdk.services.opsworks.transform.LoadBasedAutoScalingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBasedAutoScalingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, LoadBasedAutoScalingConfiguration> {
    private final String layerId;
    private final Boolean enable;
    private final AutoScalingThresholds upScaling;
    private final AutoScalingThresholds downScaling;

    private LoadBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.enable = builder.enable;
        this.upScaling = builder.upScaling;
        this.downScaling = builder.downScaling;
    }

    public String layerId() {
        return this.layerId;
    }

    public Boolean enable() {
        return this.enable;
    }

    public AutoScalingThresholds upScaling() {
        return this.upScaling;
    }

    public AutoScalingThresholds downScaling() {
        return this.downScaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.layerId() == null ? 0 : this.layerId().hashCode());
        hashCode = 31 * hashCode + (this.enable() == null ? 0 : this.enable().hashCode());
        hashCode = 31 * hashCode + (this.upScaling() == null ? 0 : this.upScaling().hashCode());
        hashCode = 31 * hashCode + (this.downScaling() == null ? 0 : this.downScaling().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBasedAutoScalingConfiguration)) {
            return false;
        }
        LoadBasedAutoScalingConfiguration other = (LoadBasedAutoScalingConfiguration)obj;
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        if (other.enable() == null ^ this.enable() == null) {
            return false;
        }
        if (other.enable() != null && !other.enable().equals(this.enable())) {
            return false;
        }
        if (other.upScaling() == null ^ this.upScaling() == null) {
            return false;
        }
        if (other.upScaling() != null && !other.upScaling().equals(this.upScaling())) {
            return false;
        }
        if (other.downScaling() == null ^ this.downScaling() == null) {
            return false;
        }
        return other.downScaling() == null || other.downScaling().equals(this.downScaling());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.layerId() != null) {
            sb.append("LayerId: ").append(this.layerId()).append(",");
        }
        if (this.enable() != null) {
            sb.append("Enable: ").append(this.enable()).append(",");
        }
        if (this.upScaling() != null) {
            sb.append("UpScaling: ").append(this.upScaling()).append(",");
        }
        if (this.downScaling() != null) {
            sb.append("DownScaling: ").append(this.downScaling()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBasedAutoScalingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String layerId;
        private Boolean enable;
        private AutoScalingThresholds upScaling;
        private AutoScalingThresholds downScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBasedAutoScalingConfiguration model) {
            this.setLayerId(model.layerId);
            this.setEnable(model.enable);
            this.setUpScaling(model.upScaling);
            this.setDownScaling(model.downScaling);
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final AutoScalingThresholds getUpScaling() {
            return this.upScaling;
        }

        @Override
        public final Builder upScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
            return this;
        }

        public final void setUpScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
        }

        public final AutoScalingThresholds getDownScaling() {
            return this.downScaling;
        }

        @Override
        public final Builder downScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
            return this;
        }

        public final void setDownScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
        }

        public LoadBasedAutoScalingConfiguration build() {
            return new LoadBasedAutoScalingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBasedAutoScalingConfiguration> {
        public Builder layerId(String var1);

        public Builder enable(Boolean var1);

        public Builder upScaling(AutoScalingThresholds var1);

        public Builder downScaling(AutoScalingThresholds var1);
    }
}

