/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.SourceType;
import software.amazon.awssdk.services.opsworks.transform.SourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Source
implements StructuredPojo,
ToCopyableBuilder<Builder, Source> {
    private final String type;
    private final String url;
    private final String username;
    private final String password;
    private final String sshKey;
    private final String revision;

    private Source(BuilderImpl builder) {
        this.type = builder.type;
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.sshKey = builder.sshKey;
        this.revision = builder.revision;
    }

    public String type() {
        return this.type;
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String sshKey() {
        return this.sshKey;
    }

    public String revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        hashCode = 31 * hashCode + (this.username() == null ? 0 : this.username().hashCode());
        hashCode = 31 * hashCode + (this.password() == null ? 0 : this.password().hashCode());
        hashCode = 31 * hashCode + (this.sshKey() == null ? 0 : this.sshKey().hashCode());
        hashCode = 31 * hashCode + (this.revision() == null ? 0 : this.revision().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.password() == null ^ this.password() == null) {
            return false;
        }
        if (other.password() != null && !other.password().equals(this.password())) {
            return false;
        }
        if (other.sshKey() == null ^ this.sshKey() == null) {
            return false;
        }
        if (other.sshKey() != null && !other.sshKey().equals(this.sshKey())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        return other.revision() == null || other.revision().equals(this.revision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        if (this.password() != null) {
            sb.append("Password: ").append(this.password()).append(",");
        }
        if (this.sshKey() != null) {
            sb.append("SshKey: ").append(this.sshKey()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String url;
        private String username;
        private String password;
        private String sshKey;
        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.setType(model.type);
            this.setUrl(model.url);
            this.setUsername(model.username);
            this.setPassword(model.password);
            this.setSshKey(model.sshKey);
            this.setRevision(model.revision);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(SourceType type) {
            this.type(type.toString());
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getSshKey() {
            return this.sshKey;
        }

        @Override
        public final Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        public final void setSshKey(String sshKey) {
            this.sshKey = sshKey;
        }

        public final String getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        public Source build() {
            return new Source(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Source> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder url(String var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder sshKey(String var1);

        public Builder revision(String var1);
    }
}

