/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>CreateUserProfile</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateUserProfileResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateUserProfileResponse.Builder, CreateUserProfileResponse> {
    private final String iamUserArn;

    private CreateUserProfileResponse(BuilderImpl builder) {
        this.iamUserArn = builder.iamUserArn;
    }

    /**
     * <p>
     * The user's IAM ARN.
     * </p>
     * 
     * @return The user's IAM ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((iamUserArn() == null) ? 0 : iamUserArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileResponse)) {
            return false;
        }
        CreateUserProfileResponse other = (CreateUserProfileResponse) obj;
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (iamUserArn() != null) {
            sb.append("IamUserArn: ").append(iamUserArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateUserProfileResponse> {
        /**
         * <p>
         * The user's IAM ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);
    }

    private static final class BuilderImpl implements Builder {
        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileResponse model) {
            setIamUserArn(model.iamUserArn);
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public CreateUserProfileResponse build() {
            return new CreateUserProfileResponse(this);
        }
    }
}
