/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteInstanceRequest.Builder, DeleteInstanceRequest> {
    private final String instanceId;

    private final Boolean deleteElasticIp;

    private final Boolean deleteVolumes;

    private DeleteInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.deleteElasticIp = builder.deleteElasticIp;
        this.deleteVolumes = builder.deleteVolumes;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Whether to delete the instance Elastic IP address.
     * </p>
     * 
     * @return Whether to delete the instance Elastic IP address.
     */
    public Boolean deleteElasticIp() {
        return deleteElasticIp;
    }

    /**
     * <p>
     * Whether to delete the instance's Amazon EBS volumes.
     * </p>
     * 
     * @return Whether to delete the instance's Amazon EBS volumes.
     */
    public Boolean deleteVolumes() {
        return deleteVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((deleteElasticIp() == null) ? 0 : deleteElasticIp().hashCode());
        hashCode = 31 * hashCode + ((deleteVolumes() == null) ? 0 : deleteVolumes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceRequest)) {
            return false;
        }
        DeleteInstanceRequest other = (DeleteInstanceRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.deleteElasticIp() == null ^ this.deleteElasticIp() == null) {
            return false;
        }
        if (other.deleteElasticIp() != null && !other.deleteElasticIp().equals(this.deleteElasticIp())) {
            return false;
        }
        if (other.deleteVolumes() == null ^ this.deleteVolumes() == null) {
            return false;
        }
        if (other.deleteVolumes() != null && !other.deleteVolumes().equals(this.deleteVolumes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (deleteElasticIp() != null) {
            sb.append("DeleteElasticIp: ").append(deleteElasticIp()).append(",");
        }
        if (deleteVolumes() != null) {
            sb.append("DeleteVolumes: ").append(deleteVolumes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteInstanceRequest> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Whether to delete the instance Elastic IP address.
         * </p>
         * 
         * @param deleteElasticIp
         *        Whether to delete the instance Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteElasticIp(Boolean deleteElasticIp);

        /**
         * <p>
         * Whether to delete the instance's Amazon EBS volumes.
         * </p>
         * 
         * @param deleteVolumes
         *        Whether to delete the instance's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteVolumes(Boolean deleteVolumes);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private Boolean deleteElasticIp;

        private Boolean deleteVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceRequest model) {
            setInstanceId(model.instanceId);
            setDeleteElasticIp(model.deleteElasticIp);
            setDeleteVolumes(model.deleteVolumes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getDeleteElasticIp() {
            return deleteElasticIp;
        }

        @Override
        public final Builder deleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
            return this;
        }

        public final void setDeleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
        }

        public final Boolean getDeleteVolumes() {
            return deleteVolumes;
        }

        @Override
        public final Builder deleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
            return this;
        }

        public final void setDeleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
        }

        @Override
        public DeleteInstanceRequest build() {
            return new DeleteInstanceRequest(this);
        }
    }
}
