/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.LifecycleEventConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the lifecycle event configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleEventConfiguration implements StructuredPojo,
        ToCopyableBuilder<LifecycleEventConfiguration.Builder, LifecycleEventConfiguration> {
    private final ShutdownEventConfiguration shutdown;

    private LifecycleEventConfiguration(BuilderImpl builder) {
        this.shutdown = builder.shutdown;
    }

    /**
     * <p>
     * A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
     * </p>
     * 
     * @return A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
     */
    public ShutdownEventConfiguration shutdown() {
        return shutdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((shutdown() == null) ? 0 : shutdown().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleEventConfiguration)) {
            return false;
        }
        LifecycleEventConfiguration other = (LifecycleEventConfiguration) obj;
        if (other.shutdown() == null ^ this.shutdown() == null) {
            return false;
        }
        if (other.shutdown() != null && !other.shutdown().equals(this.shutdown())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (shutdown() != null) {
            sb.append("Shutdown: ").append(shutdown()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LifecycleEventConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleEventConfiguration> {
        /**
         * <p>
         * A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * 
         * @param shutdown
         *        A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdown(ShutdownEventConfiguration shutdown);
    }

    private static final class BuilderImpl implements Builder {
        private ShutdownEventConfiguration shutdown;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleEventConfiguration model) {
            setShutdown(model.shutdown);
        }

        public final ShutdownEventConfiguration getShutdown() {
            return shutdown;
        }

        @Override
        public final Builder shutdown(ShutdownEventConfiguration shutdown) {
            this.shutdown = shutdown;
            return this;
        }

        public final void setShutdown(ShutdownEventConfiguration shutdown) {
            this.shutdown = shutdown;
        }

        @Override
        public LifecycleEventConfiguration build() {
            return new LifecycleEventConfiguration(this);
        }
    }
}
