/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.Architecture;
import software.amazon.awssdk.services.opsworks.model.AutoScalingType;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.opsworks.model.RootDeviceType;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateInstanceRequest> {
    private final String stackId;
    private final List<String> layerIds;
    private final String instanceType;
    private final String autoScalingType;
    private final String hostname;
    private final String os;
    private final String amiId;
    private final String sshKeyName;
    private final String availabilityZone;
    private final String virtualizationType;
    private final String subnetId;
    private final String architecture;
    private final String rootDeviceType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean installUpdatesOnBoot;
    private final Boolean ebsOptimized;
    private final String agentVersion;
    private final String tenancy;

    private CreateInstanceRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.layerIds = builder.layerIds;
        this.instanceType = builder.instanceType;
        this.autoScalingType = builder.autoScalingType;
        this.hostname = builder.hostname;
        this.os = builder.os;
        this.amiId = builder.amiId;
        this.sshKeyName = builder.sshKeyName;
        this.availabilityZone = builder.availabilityZone;
        this.virtualizationType = builder.virtualizationType;
        this.subnetId = builder.subnetId;
        this.architecture = builder.architecture;
        this.rootDeviceType = builder.rootDeviceType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.ebsOptimized = builder.ebsOptimized;
        this.agentVersion = builder.agentVersion;
        this.tenancy = builder.tenancy;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String autoScalingType() {
        return this.autoScalingType;
    }

    public String hostname() {
        return this.hostname;
    }

    public String os() {
        return this.os;
    }

    public String amiId() {
        return this.amiId;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String virtualizationType() {
        return this.virtualizationType;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String architecture() {
        return this.architecture;
    }

    public String rootDeviceType() {
        return this.rootDeviceType;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public String tenancy() {
        return this.tenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.layerIds() == null ? 0 : this.layerIds().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingType() == null ? 0 : this.autoScalingType().hashCode());
        hashCode = 31 * hashCode + (this.hostname() == null ? 0 : this.hostname().hashCode());
        hashCode = 31 * hashCode + (this.os() == null ? 0 : this.os().hashCode());
        hashCode = 31 * hashCode + (this.amiId() == null ? 0 : this.amiId().hashCode());
        hashCode = 31 * hashCode + (this.sshKeyName() == null ? 0 : this.sshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.virtualizationType() == null ? 0 : this.virtualizationType().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceType() == null ? 0 : this.rootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.installUpdatesOnBoot() == null ? 0 : this.installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.agentVersion() == null ? 0 : this.agentVersion().hashCode());
        hashCode = 31 * hashCode + (this.tenancy() == null ? 0 : this.tenancy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceRequest)) {
            return false;
        }
        CreateInstanceRequest other = (CreateInstanceRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        if (other.layerIds() != null && !other.layerIds().equals(this.layerIds())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.autoScalingType() == null ^ this.autoScalingType() == null) {
            return false;
        }
        if (other.autoScalingType() != null && !other.autoScalingType().equals(this.autoScalingType())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.os() == null ^ this.os() == null) {
            return false;
        }
        if (other.os() != null && !other.os().equals(this.os())) {
            return false;
        }
        if (other.amiId() == null ^ this.amiId() == null) {
            return false;
        }
        if (other.amiId() != null && !other.amiId().equals(this.amiId())) {
            return false;
        }
        if (other.sshKeyName() == null ^ this.sshKeyName() == null) {
            return false;
        }
        if (other.sshKeyName() != null && !other.sshKeyName().equals(this.sshKeyName())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.virtualizationType() == null ^ this.virtualizationType() == null) {
            return false;
        }
        if (other.virtualizationType() != null && !other.virtualizationType().equals(this.virtualizationType())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.rootDeviceType() == null ^ this.rootDeviceType() == null) {
            return false;
        }
        if (other.rootDeviceType() != null && !other.rootDeviceType().equals(this.rootDeviceType())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        if (other.tenancy() == null ^ this.tenancy() == null) {
            return false;
        }
        return other.tenancy() == null || other.tenancy().equals(this.tenancy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.layerIds() != null) {
            sb.append("LayerIds: ").append(this.layerIds()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.autoScalingType() != null) {
            sb.append("AutoScalingType: ").append(this.autoScalingType()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.os() != null) {
            sb.append("Os: ").append(this.os()).append(",");
        }
        if (this.amiId() != null) {
            sb.append("AmiId: ").append(this.amiId()).append(",");
        }
        if (this.sshKeyName() != null) {
            sb.append("SshKeyName: ").append(this.sshKeyName()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.virtualizationType() != null) {
            sb.append("VirtualizationType: ").append(this.virtualizationType()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.rootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(this.rootDeviceType()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.installUpdatesOnBoot()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.agentVersion() != null) {
            sb.append("AgentVersion: ").append(this.agentVersion()).append(",");
        }
        if (this.tenancy() != null) {
            sb.append("Tenancy: ").append(this.tenancy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private List<String> layerIds;
        private String instanceType;
        private String autoScalingType;
        private String hostname;
        private String os;
        private String amiId;
        private String sshKeyName;
        private String availabilityZone;
        private String virtualizationType;
        private String subnetId;
        private String architecture;
        private String rootDeviceType;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private Boolean installUpdatesOnBoot;
        private Boolean ebsOptimized;
        private String agentVersion;
        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceRequest model) {
            this.setStackId(model.stackId);
            this.setLayerIds(model.layerIds);
            this.setInstanceType(model.instanceType);
            this.setAutoScalingType(model.autoScalingType);
            this.setHostname(model.hostname);
            this.setOs(model.os);
            this.setAmiId(model.amiId);
            this.setSshKeyName(model.sshKeyName);
            this.setAvailabilityZone(model.availabilityZone);
            this.setVirtualizationType(model.virtualizationType);
            this.setSubnetId(model.subnetId);
            this.setArchitecture(model.architecture);
            this.setRootDeviceType(model.rootDeviceType);
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setInstallUpdatesOnBoot(model.installUpdatesOnBoot);
            this.setEbsOptimized(model.ebsOptimized);
            this.setAgentVersion(model.agentVersion);
            this.setTenancy(model.tenancy);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAutoScalingType() {
            return this.autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public CreateInstanceRequest build() {
            return new CreateInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInstanceRequest> {
        public Builder stackId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder instanceType(String var1);

        public Builder autoScalingType(String var1);

        public Builder autoScalingType(AutoScalingType var1);

        public Builder hostname(String var1);

        public Builder os(String var1);

        public Builder amiId(String var1);

        public Builder sshKeyName(String var1);

        public Builder availabilityZone(String var1);

        public Builder virtualizationType(String var1);

        public Builder subnetId(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(RootDeviceType var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder agentVersion(String var1);

        public Builder tenancy(String var1);
    }
}

