/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.transform.RecipesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Recipes
implements StructuredPojo,
ToCopyableBuilder<Builder, Recipes> {
    private final List<String> setup;
    private final List<String> configure;
    private final List<String> deploy;
    private final List<String> undeploy;
    private final List<String> shutdown;

    private Recipes(BuilderImpl builder) {
        this.setup = builder.setup;
        this.configure = builder.configure;
        this.deploy = builder.deploy;
        this.undeploy = builder.undeploy;
        this.shutdown = builder.shutdown;
    }

    public List<String> setup() {
        return this.setup;
    }

    public List<String> configure() {
        return this.configure;
    }

    public List<String> deploy() {
        return this.deploy;
    }

    public List<String> undeploy() {
        return this.undeploy;
    }

    public List<String> shutdown() {
        return this.shutdown;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.setup() == null ? 0 : this.setup().hashCode());
        hashCode = 31 * hashCode + (this.configure() == null ? 0 : this.configure().hashCode());
        hashCode = 31 * hashCode + (this.deploy() == null ? 0 : this.deploy().hashCode());
        hashCode = 31 * hashCode + (this.undeploy() == null ? 0 : this.undeploy().hashCode());
        hashCode = 31 * hashCode + (this.shutdown() == null ? 0 : this.shutdown().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipes)) {
            return false;
        }
        Recipes other = (Recipes)obj;
        if (other.setup() == null ^ this.setup() == null) {
            return false;
        }
        if (other.setup() != null && !other.setup().equals(this.setup())) {
            return false;
        }
        if (other.configure() == null ^ this.configure() == null) {
            return false;
        }
        if (other.configure() != null && !other.configure().equals(this.configure())) {
            return false;
        }
        if (other.deploy() == null ^ this.deploy() == null) {
            return false;
        }
        if (other.deploy() != null && !other.deploy().equals(this.deploy())) {
            return false;
        }
        if (other.undeploy() == null ^ this.undeploy() == null) {
            return false;
        }
        if (other.undeploy() != null && !other.undeploy().equals(this.undeploy())) {
            return false;
        }
        if (other.shutdown() == null ^ this.shutdown() == null) {
            return false;
        }
        return other.shutdown() == null || other.shutdown().equals(this.shutdown());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.setup() != null) {
            sb.append("Setup: ").append(this.setup()).append(",");
        }
        if (this.configure() != null) {
            sb.append("Configure: ").append(this.configure()).append(",");
        }
        if (this.deploy() != null) {
            sb.append("Deploy: ").append(this.deploy()).append(",");
        }
        if (this.undeploy() != null) {
            sb.append("Undeploy: ").append(this.undeploy()).append(",");
        }
        if (this.shutdown() != null) {
            sb.append("Shutdown: ").append(this.shutdown()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecipesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> setup;
        private List<String> configure;
        private List<String> deploy;
        private List<String> undeploy;
        private List<String> shutdown;

        private BuilderImpl() {
        }

        private BuilderImpl(Recipes model) {
            this.setSetup(model.setup);
            this.setConfigure(model.configure);
            this.setDeploy(model.deploy);
            this.setUndeploy(model.undeploy);
            this.setShutdown(model.shutdown);
        }

        public final Collection<String> getSetup() {
            return this.setup;
        }

        @Override
        public final Builder setup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setup(String ... setup) {
            this.setup(Arrays.asList(setup));
            return this;
        }

        public final void setSetup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
        }

        public final Collection<String> getConfigure() {
            return this.configure;
        }

        @Override
        public final Builder configure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configure(String ... configure) {
            this.configure(Arrays.asList(configure));
            return this;
        }

        public final void setConfigure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
        }

        public final Collection<String> getDeploy() {
            return this.deploy;
        }

        @Override
        public final Builder deploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploy(String ... deploy) {
            this.deploy(Arrays.asList(deploy));
            return this;
        }

        public final void setDeploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
        }

        public final Collection<String> getUndeploy() {
            return this.undeploy;
        }

        @Override
        public final Builder undeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undeploy(String ... undeploy) {
            this.undeploy(Arrays.asList(undeploy));
            return this;
        }

        public final void setUndeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
        }

        public final Collection<String> getShutdown() {
            return this.shutdown;
        }

        @Override
        public final Builder shutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shutdown(String ... shutdown) {
            this.shutdown(Arrays.asList(shutdown));
            return this;
        }

        public final void setShutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
        }

        public Recipes build() {
            return new Recipes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Recipes> {
        public Builder setup(Collection<String> var1);

        public Builder setup(String ... var1);

        public Builder configure(Collection<String> var1);

        public Builder configure(String ... var1);

        public Builder deploy(Collection<String> var1);

        public Builder deploy(String ... var1);

        public Builder undeploy(Collection<String> var1);

        public Builder undeploy(String ... var1);

        public Builder shutdown(Collection<String> var1);

        public Builder shutdown(String ... var1);
    }
}

