/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CreateInstanceRequest;

@SdkInternalApi
public class CreateInstanceRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<String> AUTOSCALINGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingType").build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hostname").build();
    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Os").build();
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiId").build();
    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKeyName").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<String> VIRTUALIZATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VirtualizationType").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").build();
    private static final MarshallingInfo<String> ROOTDEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootDeviceType").build();
    private static final MarshallingInfo<List> BLOCKDEVICEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockDeviceMappings").build();
    private static final MarshallingInfo<Boolean> INSTALLUPDATESONBOOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstallUpdatesOnBoot").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").build();
    private static final MarshallingInfo<String> TENANCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tenancy").build();
    private static final CreateInstanceRequestModelMarshaller INSTANCE = new CreateInstanceRequestModelMarshaller();

    public static CreateInstanceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateInstanceRequest createInstanceRequest, ProtocolMarshaller protocolMarshaller) {
        if (createInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createInstanceRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.autoScalingType(), AUTOSCALINGTYPE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.hostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.os(), OS_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.sshKeyName(), SSHKEYNAME_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.virtualizationType(), VIRTUALIZATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.architecture(), ARCHITECTURE_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.rootDeviceType(), ROOTDEVICETYPE_BINDING);
            protocolMarshaller.marshall(createInstanceRequest.blockDeviceMappings(), BLOCKDEVICEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.installUpdatesOnBoot(), INSTALLUPDATESONBOOT_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.ebsOptimized(), EBSOPTIMIZED_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)createInstanceRequest.tenancy(), TENANCY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

