/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.AgentVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an agent version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AgentVersion implements StructuredPojo, ToCopyableBuilder<AgentVersion.Builder, AgentVersion> {
    private final String version;

    private final StackConfigurationManager configurationManager;

    private AgentVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.configurationManager = builder.configurationManager;
    }

    /**
     * <p>
     * The agent version.
     * </p>
     * 
     * @return The agent version.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * The configuration manager.
     * </p>
     * 
     * @return The configuration manager.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((configurationManager() == null) ? 0 : configurationManager().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersion)) {
            return false;
        }
        AgentVersion other = (AgentVersion) obj;
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        if (other.configurationManager() != null && !other.configurationManager().equals(this.configurationManager())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(configurationManager()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgentVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AgentVersion> {
        /**
         * <p>
         * The agent version.
         * </p>
         * 
         * @param version
         *        The agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The configuration manager.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);
    }

    private static final class BuilderImpl implements Builder {
        private String version;

        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersion model) {
            setVersion(model.version);
            setConfigurationManager(model.configurationManager);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final StackConfigurationManager getConfigurationManager() {
            return configurationManager;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
        }

        @Override
        public AgentVersion build() {
            return new AgentVersion(this);
        }
    }
}
