/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>CreateStack</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStackResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateStackResponse.Builder, CreateStackResponse> {
    private final String stackId;

    private CreateStackResponse(BuilderImpl builder) {
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * The stack ID, which is an opaque string that you use to identify the stack when performing actions such as
     * <code>DescribeStacks</code>.
     * </p>
     * 
     * @return The stack ID, which is an opaque string that you use to identify the stack when performing actions such
     *         as <code>DescribeStacks</code>.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackResponse)) {
            return false;
        }
        CreateStackResponse other = (CreateStackResponse) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStackResponse> {
        /**
         * <p>
         * The stack ID, which is an opaque string that you use to identify the stack when performing actions such as
         * <code>DescribeStacks</code>.
         * </p>
         * 
         * @param stackId
         *        The stack ID, which is an opaque string that you use to identify the stack when performing actions
         *        such as <code>DescribeStacks</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackResponse model) {
            setStackId(model.stackId);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public CreateStackResponse build() {
            return new CreateStackResponse(this);
        }
    }
}
