/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeElasticIps</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeElasticIpsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeElasticIpsResponse.Builder, DescribeElasticIpsResponse> {
    private final List<ElasticIp> elasticIps;

    private DescribeElasticIpsResponse(BuilderImpl builder) {
        this.elasticIps = builder.elasticIps;
    }

    /**
     * <p>
     * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
     */
    public List<ElasticIp> elasticIps() {
        return elasticIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((elasticIps() == null) ? 0 : elasticIps().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsResponse)) {
            return false;
        }
        DescribeElasticIpsResponse other = (DescribeElasticIpsResponse) obj;
        if (other.elasticIps() == null ^ this.elasticIps() == null) {
            return false;
        }
        if (other.elasticIps() != null && !other.elasticIps().equals(this.elasticIps())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (elasticIps() != null) {
            sb.append("ElasticIps: ").append(elasticIps()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeElasticIpsResponse> {
        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * 
         * @param elasticIps
         *        An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIps(Collection<ElasticIp> elasticIps);

        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * 
         * @param elasticIps
         *        An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIps(ElasticIp... elasticIps);
    }

    private static final class BuilderImpl implements Builder {
        private List<ElasticIp> elasticIps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsResponse model) {
            setElasticIps(model.elasticIps);
        }

        public final Collection<ElasticIp> getElasticIps() {
            return elasticIps;
        }

        @Override
        public final Builder elasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(ElasticIp... elasticIps) {
            elasticIps(Arrays.asList(elasticIps));
            return this;
        }

        public final void setElasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
        }

        @Override
        public DescribeElasticIpsResponse build() {
            return new DescribeElasticIpsResponse(this);
        }
    }
}
