/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStackSummary</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackSummaryResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStackSummaryResponse.Builder, DescribeStackSummaryResponse> {
    private final StackSummary stackSummary;

    private DescribeStackSummaryResponse(BuilderImpl builder) {
        this.stackSummary = builder.stackSummary;
    }

    /**
     * <p>
     * A <code>StackSummary</code> object that contains the results.
     * </p>
     * 
     * @return A <code>StackSummary</code> object that contains the results.
     */
    public StackSummary stackSummary() {
        return stackSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackSummary() == null) ? 0 : stackSummary().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSummaryResponse)) {
            return false;
        }
        DescribeStackSummaryResponse other = (DescribeStackSummaryResponse) obj;
        if (other.stackSummary() == null ^ this.stackSummary() == null) {
            return false;
        }
        if (other.stackSummary() != null && !other.stackSummary().equals(this.stackSummary())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackSummary() != null) {
            sb.append("StackSummary: ").append(stackSummary()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStackSummaryResponse> {
        /**
         * <p>
         * A <code>StackSummary</code> object that contains the results.
         * </p>
         * 
         * @param stackSummary
         *        A <code>StackSummary</code> object that contains the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSummary(StackSummary stackSummary);
    }

    private static final class BuilderImpl implements Builder {
        private StackSummary stackSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSummaryResponse model) {
            setStackSummary(model.stackSummary);
        }

        public final StackSummary getStackSummary() {
            return stackSummary;
        }

        @Override
        public final Builder stackSummary(StackSummary stackSummary) {
            this.stackSummary = stackSummary;
            return this;
        }

        public final void setStackSummary(StackSummary stackSummary) {
            this.stackSummary = stackSummary;
        }

        @Override
        public DescribeStackSummaryResponse build() {
            return new DescribeStackSummaryResponse(this);
        }
    }
}
