/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.transform.AutoScalingThresholdsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingThresholds
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingThresholds> {
    private final Integer instanceCount;
    private final Integer thresholdsWaitTime;
    private final Integer ignoreMetricsTime;
    private final Double cpuThreshold;
    private final Double memoryThreshold;
    private final Double loadThreshold;
    private final List<String> alarms;

    private AutoScalingThresholds(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.thresholdsWaitTime = builder.thresholdsWaitTime;
        this.ignoreMetricsTime = builder.ignoreMetricsTime;
        this.cpuThreshold = builder.cpuThreshold;
        this.memoryThreshold = builder.memoryThreshold;
        this.loadThreshold = builder.loadThreshold;
        this.alarms = builder.alarms;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public Integer thresholdsWaitTime() {
        return this.thresholdsWaitTime;
    }

    public Integer ignoreMetricsTime() {
        return this.ignoreMetricsTime;
    }

    public Double cpuThreshold() {
        return this.cpuThreshold;
    }

    public Double memoryThreshold() {
        return this.memoryThreshold;
    }

    public Double loadThreshold() {
        return this.loadThreshold;
    }

    public List<String> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.thresholdsWaitTime() == null ? 0 : this.thresholdsWaitTime().hashCode());
        hashCode = 31 * hashCode + (this.ignoreMetricsTime() == null ? 0 : this.ignoreMetricsTime().hashCode());
        hashCode = 31 * hashCode + (this.cpuThreshold() == null ? 0 : this.cpuThreshold().hashCode());
        hashCode = 31 * hashCode + (this.memoryThreshold() == null ? 0 : this.memoryThreshold().hashCode());
        hashCode = 31 * hashCode + (this.loadThreshold() == null ? 0 : this.loadThreshold().hashCode());
        hashCode = 31 * hashCode + (this.alarms() == null ? 0 : this.alarms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingThresholds)) {
            return false;
        }
        AutoScalingThresholds other = (AutoScalingThresholds)obj;
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.thresholdsWaitTime() == null ^ this.thresholdsWaitTime() == null) {
            return false;
        }
        if (other.thresholdsWaitTime() != null && !other.thresholdsWaitTime().equals(this.thresholdsWaitTime())) {
            return false;
        }
        if (other.ignoreMetricsTime() == null ^ this.ignoreMetricsTime() == null) {
            return false;
        }
        if (other.ignoreMetricsTime() != null && !other.ignoreMetricsTime().equals(this.ignoreMetricsTime())) {
            return false;
        }
        if (other.cpuThreshold() == null ^ this.cpuThreshold() == null) {
            return false;
        }
        if (other.cpuThreshold() != null && !other.cpuThreshold().equals(this.cpuThreshold())) {
            return false;
        }
        if (other.memoryThreshold() == null ^ this.memoryThreshold() == null) {
            return false;
        }
        if (other.memoryThreshold() != null && !other.memoryThreshold().equals(this.memoryThreshold())) {
            return false;
        }
        if (other.loadThreshold() == null ^ this.loadThreshold() == null) {
            return false;
        }
        if (other.loadThreshold() != null && !other.loadThreshold().equals(this.loadThreshold())) {
            return false;
        }
        if (other.alarms() == null ^ this.alarms() == null) {
            return false;
        }
        return other.alarms() == null || other.alarms().equals(this.alarms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.thresholdsWaitTime() != null) {
            sb.append("ThresholdsWaitTime: ").append(this.thresholdsWaitTime()).append(",");
        }
        if (this.ignoreMetricsTime() != null) {
            sb.append("IgnoreMetricsTime: ").append(this.ignoreMetricsTime()).append(",");
        }
        if (this.cpuThreshold() != null) {
            sb.append("CpuThreshold: ").append(this.cpuThreshold()).append(",");
        }
        if (this.memoryThreshold() != null) {
            sb.append("MemoryThreshold: ").append(this.memoryThreshold()).append(",");
        }
        if (this.loadThreshold() != null) {
            sb.append("LoadThreshold: ").append(this.loadThreshold()).append(",");
        }
        if (this.alarms() != null) {
            sb.append("Alarms: ").append(this.alarms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "ThresholdsWaitTime": {
                return Optional.of(clazz.cast(this.thresholdsWaitTime()));
            }
            case "IgnoreMetricsTime": {
                return Optional.of(clazz.cast(this.ignoreMetricsTime()));
            }
            case "CpuThreshold": {
                return Optional.of(clazz.cast(this.cpuThreshold()));
            }
            case "MemoryThreshold": {
                return Optional.of(clazz.cast(this.memoryThreshold()));
            }
            case "LoadThreshold": {
                return Optional.of(clazz.cast(this.loadThreshold()));
            }
            case "Alarms": {
                return Optional.of(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingThresholdsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private Integer thresholdsWaitTime;
        private Integer ignoreMetricsTime;
        private Double cpuThreshold;
        private Double memoryThreshold;
        private Double loadThreshold;
        private List<String> alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingThresholds model) {
            this.instanceCount(model.instanceCount);
            this.thresholdsWaitTime(model.thresholdsWaitTime);
            this.ignoreMetricsTime(model.ignoreMetricsTime);
            this.cpuThreshold(model.cpuThreshold);
            this.memoryThreshold(model.memoryThreshold);
            this.loadThreshold(model.loadThreshold);
            this.alarms(model.alarms);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Integer getThresholdsWaitTime() {
            return this.thresholdsWaitTime;
        }

        @Override
        public final Builder thresholdsWaitTime(Integer thresholdsWaitTime) {
            this.thresholdsWaitTime = thresholdsWaitTime;
            return this;
        }

        public final void setThresholdsWaitTime(Integer thresholdsWaitTime) {
            this.thresholdsWaitTime = thresholdsWaitTime;
        }

        public final Integer getIgnoreMetricsTime() {
            return this.ignoreMetricsTime;
        }

        @Override
        public final Builder ignoreMetricsTime(Integer ignoreMetricsTime) {
            this.ignoreMetricsTime = ignoreMetricsTime;
            return this;
        }

        public final void setIgnoreMetricsTime(Integer ignoreMetricsTime) {
            this.ignoreMetricsTime = ignoreMetricsTime;
        }

        public final Double getCpuThreshold() {
            return this.cpuThreshold;
        }

        @Override
        public final Builder cpuThreshold(Double cpuThreshold) {
            this.cpuThreshold = cpuThreshold;
            return this;
        }

        public final void setCpuThreshold(Double cpuThreshold) {
            this.cpuThreshold = cpuThreshold;
        }

        public final Double getMemoryThreshold() {
            return this.memoryThreshold;
        }

        @Override
        public final Builder memoryThreshold(Double memoryThreshold) {
            this.memoryThreshold = memoryThreshold;
            return this;
        }

        public final void setMemoryThreshold(Double memoryThreshold) {
            this.memoryThreshold = memoryThreshold;
        }

        public final Double getLoadThreshold() {
            return this.loadThreshold;
        }

        @Override
        public final Builder loadThreshold(Double loadThreshold) {
            this.loadThreshold = loadThreshold;
            return this;
        }

        public final void setLoadThreshold(Double loadThreshold) {
            this.loadThreshold = loadThreshold;
        }

        public final Collection<String> getAlarms() {
            return this.alarms;
        }

        @Override
        public final Builder alarms(Collection<String> alarms) {
            this.alarms = StringsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(String ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<String> alarms) {
            this.alarms = StringsCopier.copy(alarms);
        }

        public AutoScalingThresholds build() {
            return new AutoScalingThresholds(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingThresholds> {
        public Builder instanceCount(Integer var1);

        public Builder thresholdsWaitTime(Integer var1);

        public Builder ignoreMetricsTime(Integer var1);

        public Builder cpuThreshold(Double var1);

        public Builder memoryThreshold(Double var1);

        public Builder loadThreshold(Double var1);

        public Builder alarms(Collection<String> var1);

        public Builder alarms(String ... var1);
    }
}

