/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVolumesRequest> {
    private final String instanceId;
    private final String stackId;
    private final String raidArrayId;
    private final List<String> volumeIds;

    private DescribeVolumesRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.raidArrayId = builder.raidArrayId;
        this.volumeIds = builder.volumeIds;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String raidArrayId() {
        return this.raidArrayId;
    }

    public List<String> volumeIds() {
        return this.volumeIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.raidArrayId() == null ? 0 : this.raidArrayId().hashCode());
        hashCode = 31 * hashCode + (this.volumeIds() == null ? 0 : this.volumeIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesRequest)) {
            return false;
        }
        DescribeVolumesRequest other = (DescribeVolumesRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.raidArrayId() == null ^ this.raidArrayId() == null) {
            return false;
        }
        if (other.raidArrayId() != null && !other.raidArrayId().equals(this.raidArrayId())) {
            return false;
        }
        if (other.volumeIds() == null ^ this.volumeIds() == null) {
            return false;
        }
        return other.volumeIds() == null || other.volumeIds().equals(this.volumeIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.raidArrayId() != null) {
            sb.append("RaidArrayId: ").append(this.raidArrayId()).append(",");
        }
        if (this.volumeIds() != null) {
            sb.append("VolumeIds: ").append(this.volumeIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "RaidArrayId": {
                return Optional.of(clazz.cast(this.raidArrayId()));
            }
            case "VolumeIds": {
                return Optional.of(clazz.cast(this.volumeIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String stackId;
        private String raidArrayId;
        private List<String> volumeIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesRequest model) {
            this.instanceId(model.instanceId);
            this.stackId(model.stackId);
            this.raidArrayId(model.raidArrayId);
            this.volumeIds(model.volumeIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRaidArrayId() {
            return this.raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final Collection<String> getVolumeIds() {
            return this.volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = StringsCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String ... volumeIds) {
            this.volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = StringsCopier.copy(volumeIds);
        }

        public DescribeVolumesRequest build() {
            return new DescribeVolumesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVolumesRequest> {
        public Builder instanceId(String var1);

        public Builder stackId(String var1);

        public Builder raidArrayId(String var1);

        public Builder volumeIds(Collection<String> var1);

        public Builder volumeIds(String ... var1);
    }
}

