/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.VolumeType;
import software.amazon.awssdk.services.opsworks.transform.EbsBlockDeviceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsBlockDevice
implements StructuredPojo,
ToCopyableBuilder<Builder, EbsBlockDevice> {
    private final String snapshotId;
    private final Integer iops;
    private final Integer volumeSize;
    private final String volumeType;
    private final Boolean deleteOnTermination;

    private EbsBlockDevice(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.iops = builder.iops;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Integer iops() {
        return this.iops;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public String volumeTypeString() {
        return this.volumeType;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.volumeSize() == null ? 0 : this.volumeSize().hashCode());
        hashCode = 31 * hashCode + (this.volumeTypeString() == null ? 0 : this.volumeTypeString().hashCode());
        hashCode = 31 * hashCode + (this.deleteOnTermination() == null ? 0 : this.deleteOnTermination().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice)obj;
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.volumeSize() == null ^ this.volumeSize() == null) {
            return false;
        }
        if (other.volumeSize() != null && !other.volumeSize().equals(this.volumeSize())) {
            return false;
        }
        if (other.volumeTypeString() == null ^ this.volumeTypeString() == null) {
            return false;
        }
        if (other.volumeTypeString() != null && !other.volumeTypeString().equals(this.volumeTypeString())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        return other.deleteOnTermination() == null || other.deleteOnTermination().equals(this.deleteOnTermination());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.volumeSize() != null) {
            sb.append("VolumeSize: ").append(this.volumeSize()).append(",");
        }
        if (this.volumeTypeString() != null) {
            sb.append("VolumeType: ").append(this.volumeTypeString()).append(",");
        }
        if (this.deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(this.deleteOnTermination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
            case "VolumeSize": {
                return Optional.of(clazz.cast(this.volumeSize()));
            }
            case "VolumeType": {
                return Optional.of(clazz.cast(this.volumeTypeString()));
            }
            case "DeleteOnTermination": {
                return Optional.of(clazz.cast(this.deleteOnTermination()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsBlockDeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotId;
        private Integer iops;
        private Integer volumeSize;
        private String volumeType;
        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            this.snapshotId(model.snapshotId);
            this.iops(model.iops);
            this.volumeSize(model.volumeSize);
            this.volumeType(model.volumeType);
            this.deleteOnTermination(model.deleteOnTermination);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsBlockDevice> {
        public Builder snapshotId(String var1);

        public Builder iops(Integer var1);

        public Builder volumeSize(Integer var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder deleteOnTermination(Boolean var1);
    }
}

