/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.EnvironmentVariableMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentVariable
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentVariable> {
    private final String key;
    private final String value;
    private final Boolean secure;

    private EnvironmentVariable(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.secure = builder.secure;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Boolean secure() {
        return this.secure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.secure() == null ? 0 : this.secure().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentVariable)) {
            return false;
        }
        EnvironmentVariable other = (EnvironmentVariable)obj;
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.secure() == null ^ this.secure() == null) {
            return false;
        }
        return other.secure() == null || other.secure().equals(this.secure());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.secure() != null) {
            sb.append("Secure: ").append(this.secure()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Secure": {
                return Optional.of(clazz.cast(this.secure()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentVariableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Boolean secure;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentVariable model) {
            this.key(model.key);
            this.value(model.value);
            this.secure(model.secure);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getSecure() {
            return this.secure;
        }

        @Override
        public final Builder secure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        public final void setSecure(Boolean secure) {
            this.secure = secure;
        }

        public EnvironmentVariable build() {
            return new EnvironmentVariable(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentVariable> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder secure(Boolean var1);
    }
}

