/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsConfiguration;
import software.amazon.awssdk.services.opsworks.model.LayerAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.LayerAttributesKeys;
import software.amazon.awssdk.services.opsworks.model.LifecycleEventConfiguration;
import software.amazon.awssdk.services.opsworks.model.Recipes;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.model.VolumeConfiguration;
import software.amazon.awssdk.services.opsworks.model.VolumeConfigurationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateLayerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateLayerRequest> {
    private final String layerId;
    private final String name;
    private final String shortname;
    private final Map<String, String> attributes;
    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;
    private final String customInstanceProfileArn;
    private final String customJson;
    private final List<String> customSecurityGroupIds;
    private final List<String> packages;
    private final List<VolumeConfiguration> volumeConfigurations;
    private final Boolean enableAutoHealing;
    private final Boolean autoAssignElasticIps;
    private final Boolean autoAssignPublicIps;
    private final Recipes customRecipes;
    private final Boolean installUpdatesOnBoot;
    private final Boolean useEbsOptimizedInstances;
    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private UpdateLayerRequest(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.customRecipes = builder.customRecipes;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    public String layerId() {
        return this.layerId;
    }

    public String name() {
        return this.name;
    }

    public String shortname() {
        return this.shortname;
    }

    public Map<LayerAttributesKeys, String> attributes() {
        return TypeConverter.convert(this.attributes, LayerAttributesKeys::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)LayerAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesStrings() {
        return this.attributes;
    }

    public CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return this.cloudWatchLogsConfiguration;
    }

    public String customInstanceProfileArn() {
        return this.customInstanceProfileArn;
    }

    public String customJson() {
        return this.customJson;
    }

    public List<String> customSecurityGroupIds() {
        return this.customSecurityGroupIds;
    }

    public List<String> packages() {
        return this.packages;
    }

    public List<VolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    public Boolean enableAutoHealing() {
        return this.enableAutoHealing;
    }

    public Boolean autoAssignElasticIps() {
        return this.autoAssignElasticIps;
    }

    public Boolean autoAssignPublicIps() {
        return this.autoAssignPublicIps;
    }

    public Recipes customRecipes() {
        return this.customRecipes;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean useEbsOptimizedInstances() {
        return this.useEbsOptimizedInstances;
    }

    public LifecycleEventConfiguration lifecycleEventConfiguration() {
        return this.lifecycleEventConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.layerId() == null ? 0 : this.layerId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.shortname() == null ? 0 : this.shortname().hashCode());
        hashCode = 31 * hashCode + (this.attributesStrings() == null ? 0 : this.attributesStrings().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLogsConfiguration() == null ? 0 : this.cloudWatchLogsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.customInstanceProfileArn() == null ? 0 : this.customInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.customJson() == null ? 0 : this.customJson().hashCode());
        hashCode = 31 * hashCode + (this.customSecurityGroupIds() == null ? 0 : this.customSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.packages() == null ? 0 : this.packages().hashCode());
        hashCode = 31 * hashCode + (this.volumeConfigurations() == null ? 0 : this.volumeConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.enableAutoHealing() == null ? 0 : this.enableAutoHealing().hashCode());
        hashCode = 31 * hashCode + (this.autoAssignElasticIps() == null ? 0 : this.autoAssignElasticIps().hashCode());
        hashCode = 31 * hashCode + (this.autoAssignPublicIps() == null ? 0 : this.autoAssignPublicIps().hashCode());
        hashCode = 31 * hashCode + (this.customRecipes() == null ? 0 : this.customRecipes().hashCode());
        hashCode = 31 * hashCode + (this.installUpdatesOnBoot() == null ? 0 : this.installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.useEbsOptimizedInstances() == null ? 0 : this.useEbsOptimizedInstances().hashCode());
        hashCode = 31 * hashCode + (this.lifecycleEventConfiguration() == null ? 0 : this.lifecycleEventConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLayerRequest)) {
            return false;
        }
        UpdateLayerRequest other = (UpdateLayerRequest)((Object)obj);
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.shortname() == null ^ this.shortname() == null) {
            return false;
        }
        if (other.shortname() != null && !other.shortname().equals(this.shortname())) {
            return false;
        }
        if (other.attributesStrings() == null ^ this.attributesStrings() == null) {
            return false;
        }
        if (other.attributesStrings() != null && !other.attributesStrings().equals(this.attributesStrings())) {
            return false;
        }
        if (other.cloudWatchLogsConfiguration() == null ^ this.cloudWatchLogsConfiguration() == null) {
            return false;
        }
        if (other.cloudWatchLogsConfiguration() != null && !other.cloudWatchLogsConfiguration().equals(this.cloudWatchLogsConfiguration())) {
            return false;
        }
        if (other.customInstanceProfileArn() == null ^ this.customInstanceProfileArn() == null) {
            return false;
        }
        if (other.customInstanceProfileArn() != null && !other.customInstanceProfileArn().equals(this.customInstanceProfileArn())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.customSecurityGroupIds() == null ^ this.customSecurityGroupIds() == null) {
            return false;
        }
        if (other.customSecurityGroupIds() != null && !other.customSecurityGroupIds().equals(this.customSecurityGroupIds())) {
            return false;
        }
        if (other.packages() == null ^ this.packages() == null) {
            return false;
        }
        if (other.packages() != null && !other.packages().equals(this.packages())) {
            return false;
        }
        if (other.volumeConfigurations() == null ^ this.volumeConfigurations() == null) {
            return false;
        }
        if (other.volumeConfigurations() != null && !other.volumeConfigurations().equals(this.volumeConfigurations())) {
            return false;
        }
        if (other.enableAutoHealing() == null ^ this.enableAutoHealing() == null) {
            return false;
        }
        if (other.enableAutoHealing() != null && !other.enableAutoHealing().equals(this.enableAutoHealing())) {
            return false;
        }
        if (other.autoAssignElasticIps() == null ^ this.autoAssignElasticIps() == null) {
            return false;
        }
        if (other.autoAssignElasticIps() != null && !other.autoAssignElasticIps().equals(this.autoAssignElasticIps())) {
            return false;
        }
        if (other.autoAssignPublicIps() == null ^ this.autoAssignPublicIps() == null) {
            return false;
        }
        if (other.autoAssignPublicIps() != null && !other.autoAssignPublicIps().equals(this.autoAssignPublicIps())) {
            return false;
        }
        if (other.customRecipes() == null ^ this.customRecipes() == null) {
            return false;
        }
        if (other.customRecipes() != null && !other.customRecipes().equals(this.customRecipes())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.useEbsOptimizedInstances() == null ^ this.useEbsOptimizedInstances() == null) {
            return false;
        }
        if (other.useEbsOptimizedInstances() != null && !other.useEbsOptimizedInstances().equals(this.useEbsOptimizedInstances())) {
            return false;
        }
        if (other.lifecycleEventConfiguration() == null ^ this.lifecycleEventConfiguration() == null) {
            return false;
        }
        return other.lifecycleEventConfiguration() == null || other.lifecycleEventConfiguration().equals(this.lifecycleEventConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.layerId() != null) {
            sb.append("LayerId: ").append(this.layerId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.shortname() != null) {
            sb.append("Shortname: ").append(this.shortname()).append(",");
        }
        if (this.attributesStrings() != null) {
            sb.append("Attributes: ").append(this.attributesStrings()).append(",");
        }
        if (this.cloudWatchLogsConfiguration() != null) {
            sb.append("CloudWatchLogsConfiguration: ").append(this.cloudWatchLogsConfiguration()).append(",");
        }
        if (this.customInstanceProfileArn() != null) {
            sb.append("CustomInstanceProfileArn: ").append(this.customInstanceProfileArn()).append(",");
        }
        if (this.customJson() != null) {
            sb.append("CustomJson: ").append(this.customJson()).append(",");
        }
        if (this.customSecurityGroupIds() != null) {
            sb.append("CustomSecurityGroupIds: ").append(this.customSecurityGroupIds()).append(",");
        }
        if (this.packages() != null) {
            sb.append("Packages: ").append(this.packages()).append(",");
        }
        if (this.volumeConfigurations() != null) {
            sb.append("VolumeConfigurations: ").append(this.volumeConfigurations()).append(",");
        }
        if (this.enableAutoHealing() != null) {
            sb.append("EnableAutoHealing: ").append(this.enableAutoHealing()).append(",");
        }
        if (this.autoAssignElasticIps() != null) {
            sb.append("AutoAssignElasticIps: ").append(this.autoAssignElasticIps()).append(",");
        }
        if (this.autoAssignPublicIps() != null) {
            sb.append("AutoAssignPublicIps: ").append(this.autoAssignPublicIps()).append(",");
        }
        if (this.customRecipes() != null) {
            sb.append("CustomRecipes: ").append(this.customRecipes()).append(",");
        }
        if (this.installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.installUpdatesOnBoot()).append(",");
        }
        if (this.useEbsOptimizedInstances() != null) {
            sb.append("UseEbsOptimizedInstances: ").append(this.useEbsOptimizedInstances()).append(",");
        }
        if (this.lifecycleEventConfiguration() != null) {
            sb.append("LifecycleEventConfiguration: ").append(this.lifecycleEventConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerId": {
                return Optional.of(clazz.cast(this.layerId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Shortname": {
                return Optional.of(clazz.cast(this.shortname()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributesStrings()));
            }
            case "CloudWatchLogsConfiguration": {
                return Optional.of(clazz.cast(this.cloudWatchLogsConfiguration()));
            }
            case "CustomInstanceProfileArn": {
                return Optional.of(clazz.cast(this.customInstanceProfileArn()));
            }
            case "CustomJson": {
                return Optional.of(clazz.cast(this.customJson()));
            }
            case "CustomSecurityGroupIds": {
                return Optional.of(clazz.cast(this.customSecurityGroupIds()));
            }
            case "Packages": {
                return Optional.of(clazz.cast(this.packages()));
            }
            case "VolumeConfigurations": {
                return Optional.of(clazz.cast(this.volumeConfigurations()));
            }
            case "EnableAutoHealing": {
                return Optional.of(clazz.cast(this.enableAutoHealing()));
            }
            case "AutoAssignElasticIps": {
                return Optional.of(clazz.cast(this.autoAssignElasticIps()));
            }
            case "AutoAssignPublicIps": {
                return Optional.of(clazz.cast(this.autoAssignPublicIps()));
            }
            case "CustomRecipes": {
                return Optional.of(clazz.cast(this.customRecipes()));
            }
            case "InstallUpdatesOnBoot": {
                return Optional.of(clazz.cast(this.installUpdatesOnBoot()));
            }
            case "UseEbsOptimizedInstances": {
                return Optional.of(clazz.cast(this.useEbsOptimizedInstances()));
            }
            case "LifecycleEventConfiguration": {
                return Optional.of(clazz.cast(this.lifecycleEventConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String layerId;
        private String name;
        private String shortname;
        private Map<String, String> attributes;
        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;
        private String customInstanceProfileArn;
        private String customJson;
        private List<String> customSecurityGroupIds;
        private List<String> packages;
        private List<VolumeConfiguration> volumeConfigurations;
        private Boolean enableAutoHealing;
        private Boolean autoAssignElasticIps;
        private Boolean autoAssignPublicIps;
        private Recipes customRecipes;
        private Boolean installUpdatesOnBoot;
        private Boolean useEbsOptimizedInstances;
        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLayerRequest model) {
            this.layerId(model.layerId);
            this.name(model.name);
            this.shortname(model.shortname);
            this.attributes(model.attributes);
            this.cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            this.customInstanceProfileArn(model.customInstanceProfileArn);
            this.customJson(model.customJson);
            this.customSecurityGroupIds(model.customSecurityGroupIds);
            this.packages(model.packages);
            this.volumeConfigurations(model.volumeConfigurations);
            this.enableAutoHealing(model.enableAutoHealing);
            this.autoAssignElasticIps(model.autoAssignElasticIps);
            this.autoAssignPublicIps(model.autoAssignPublicIps);
            this.customRecipes(model.customRecipes);
            this.installUpdatesOnBoot(model.installUpdatesOnBoot);
            this.useEbsOptimizedInstances(model.useEbsOptimizedInstances);
            this.lifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortname() {
            return this.shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        public final CloudWatchLogsConfiguration.Builder getCloudWatchLogsConfiguration() {
            return this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        public final String getCustomInstanceProfileArn() {
            return this.customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            return this.customSecurityGroupIds;
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String ... customSecurityGroupIds) {
            this.customSecurityGroupIds(Arrays.asList(customSecurityGroupIds));
            return this;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        public final Collection<String> getPackages() {
            return this.packages;
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String ... packages) {
            this.packages(Arrays.asList(packages));
            return this;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        public final Collection<VolumeConfiguration.Builder> getVolumeConfigurations() {
            return this.volumeConfigurations != null ? (Collection)this.volumeConfigurations.stream().map(VolumeConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        public final Boolean getEnableAutoHealing() {
            return this.enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        public final Boolean getAutoAssignElasticIps() {
            return this.autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        public final Boolean getAutoAssignPublicIps() {
            return this.autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        public final Recipes.Builder getCustomRecipes() {
            return this.customRecipes != null ? this.customRecipes.toBuilder() : null;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final void setCustomRecipes(Recipes.BuilderImpl customRecipes) {
            this.customRecipes = customRecipes != null ? customRecipes.build() : null;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return this.useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        public final LifecycleEventConfiguration.Builder getLifecycleEventConfiguration() {
            return this.lifecycleEventConfiguration != null ? this.lifecycleEventConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration.BuilderImpl lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration != null ? lifecycleEventConfiguration.build() : null;
        }

        public UpdateLayerRequest build() {
            return new UpdateLayerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateLayerRequest> {
        public Builder layerId(String var1);

        public Builder name(String var1);

        public Builder shortname(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration var1);

        public Builder customInstanceProfileArn(String var1);

        public Builder customJson(String var1);

        public Builder customSecurityGroupIds(Collection<String> var1);

        public Builder customSecurityGroupIds(String ... var1);

        public Builder packages(Collection<String> var1);

        public Builder packages(String ... var1);

        public Builder volumeConfigurations(Collection<VolumeConfiguration> var1);

        public Builder volumeConfigurations(VolumeConfiguration ... var1);

        public Builder enableAutoHealing(Boolean var1);

        public Builder autoAssignElasticIps(Boolean var1);

        public Builder autoAssignPublicIps(Boolean var1);

        public Builder customRecipes(Recipes var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder useEbsOptimizedInstances(Boolean var1);

        public Builder lifecycleEventConfiguration(LifecycleEventConfiguration var1);
    }
}

