/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.ChefConfiguration;

public class ChefConfigurationUnmarshaller
implements Unmarshaller<ChefConfiguration, JsonUnmarshallerContext> {
    private static final ChefConfigurationUnmarshaller INSTANCE = new ChefConfigurationUnmarshaller();

    public ChefConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        ChefConfiguration.Builder chefConfigurationBuilder = ChefConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ManageBerkshelf", targetDepth)) {
                    context.nextToken();
                    chefConfigurationBuilder.manageBerkshelf((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("BerkshelfVersion", targetDepth)) {
                    context.nextToken();
                    chefConfigurationBuilder.berkshelfVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ChefConfiguration)chefConfigurationBuilder.build();
    }

    public static ChefConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

