/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeEcsClusters</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeEcsClustersResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeEcsClustersResponse.Builder, DescribeEcsClustersResponse> {
    private final List<EcsCluster> ecsClusters;

    private final String nextToken;

    private DescribeEcsClustersResponse(BuilderImpl builder) {
        super(builder);
        this.ecsClusters = builder.ecsClusters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>EcsCluster</code> objects containing the cluster descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>EcsCluster</code> objects containing the cluster descriptions.
     */
    public List<EcsCluster> ecsClusters() {
        return ecsClusters;
    }

    /**
     * <p>
     * If a paginated request does not return all of the remaining results, this parameter is set to a token that you
     * can assign to the request object's <code>NextToken</code> parameter to retrieve the next set of results. If the
     * previous paginated request returned all of the remaining results, this parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If a paginated request does not return all of the remaining results, this parameter is set to a token
     *         that you can assign to the request object's <code>NextToken</code> parameter to retrieve the next set of
     *         results. If the previous paginated request returned all of the remaining results, this parameter is set
     *         to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersResponse)) {
            return false;
        }
        DescribeEcsClustersResponse other = (DescribeEcsClustersResponse) obj;
        return Objects.equals(ecsClusters(), other.ecsClusters()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ecsClusters() != null) {
            sb.append("EcsClusters: ").append(ecsClusters()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EcsClusters":
            return Optional.of(clazz.cast(ecsClusters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeEcsClustersResponse> {
        /**
         * <p>
         * A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * </p>
         * 
         * @param ecsClusters
         *        A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusters(Collection<EcsCluster> ecsClusters);

        /**
         * <p>
         * A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * </p>
         * 
         * @param ecsClusters
         *        A list of <code>EcsCluster</code> objects containing the cluster descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusters(EcsCluster... ecsClusters);

        /**
         * <p>
         * If a paginated request does not return all of the remaining results, this parameter is set to a token that
         * you can assign to the request object's <code>NextToken</code> parameter to retrieve the next set of results.
         * If the previous paginated request returned all of the remaining results, this parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If a paginated request does not return all of the remaining results, this parameter is set to a token
         *        that you can assign to the request object's <code>NextToken</code> parameter to retrieve the next set
         *        of results. If the previous paginated request returned all of the remaining results, this parameter is
         *        set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<EcsCluster> ecsClusters;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersResponse model) {
            ecsClusters(model.ecsClusters);
            nextToken(model.nextToken);
        }

        public final Collection<EcsCluster.Builder> getEcsClusters() {
            return ecsClusters != null ? ecsClusters.stream().map(EcsCluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ecsClusters(Collection<EcsCluster> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copy(ecsClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusters(EcsCluster... ecsClusters) {
            ecsClusters(Arrays.asList(ecsClusters));
            return this;
        }

        public final void setEcsClusters(Collection<EcsCluster.BuilderImpl> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copyFromBuilder(ecsClusters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEcsClustersResponse build() {
            return new DescribeEcsClustersResponse(this);
        }
    }
}
