/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancesRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeInstancesRequest.Builder, DescribeInstancesRequest> {
    private final String stackId;

    private final String layerId;

    private final List<String> instanceIds;

    private DescribeInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.instanceIds = builder.instanceIds;
    }

    /**
     * <p>
     * A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances
     * associated with the specified stack.
     * </p>
     * 
     * @return A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the
     *         instances associated with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances
     * associated with the specified layer.
     * </p>
     * 
     * @return A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the
     *         instances associated with the specified layer.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a
     * description of the specified instances. Otherwise, it returns a description of every instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code>
     *         returns a description of the specified instances. Otherwise, it returns a description of every instance.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesRequest)) {
            return false;
        }
        DescribeInstancesRequest other = (DescribeInstancesRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(layerId(), other.layerId())
                && Objects.equals(instanceIds(), other.instanceIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (layerId() != null) {
            sb.append("LayerId: ").append(layerId()).append(",");
        }
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "LayerId":
            return Optional.of(clazz.cast(layerId()));
        case "InstanceIds":
            return Optional.of(clazz.cast(instanceIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksRequest.Builder, CopyableBuilder<Builder, DescribeInstancesRequest> {
        /**
         * <p>
         * A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances
         * associated with the specified stack.
         * </p>
         * 
         * @param stackId
         *        A stack ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the
         *        instances associated with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the instances
         * associated with the specified layer.
         * </p>
         * 
         * @param layerId
         *        A layer ID. If you use this parameter, <code>DescribeInstances</code> returns descriptions of the
         *        instances associated with the specified layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a
         * description of the specified instances. Otherwise, it returns a description of every instance.
         * </p>
         * 
         * @param instanceIds
         *        An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code>
         *        returns a description of the specified instances. Otherwise, it returns a description of every
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code> returns a
         * description of the specified instances. Otherwise, it returns a description of every instance.
         * </p>
         * 
         * @param instanceIds
         *        An array of instance IDs to be described. If you use this parameter, <code>DescribeInstances</code>
         *        returns a description of the specified instances. Otherwise, it returns a description of every
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String layerId;

        private List<String> instanceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesRequest model) {
            stackId(model.stackId);
            layerId(model.layerId);
            instanceIds(model.instanceIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancesRequest build() {
            return new DescribeInstancesRequest(this);
        }
    }
}
