/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeServiceErrors</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeServiceErrorsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeServiceErrorsResponse.Builder, DescribeServiceErrorsResponse> {
    private final List<ServiceError> serviceErrors;

    private DescribeServiceErrorsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceErrors = builder.serviceErrors;
    }

    /**
     * <p>
     * An array of <code>ServiceError</code> objects that describe the specified service errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>ServiceError</code> objects that describe the specified service errors.
     */
    public List<ServiceError> serviceErrors() {
        return serviceErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceErrors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsResponse)) {
            return false;
        }
        DescribeServiceErrorsResponse other = (DescribeServiceErrorsResponse) obj;
        return Objects.equals(serviceErrors(), other.serviceErrors());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (serviceErrors() != null) {
            sb.append("ServiceErrors: ").append(serviceErrors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceErrors":
            return Optional.of(clazz.cast(serviceErrors()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeServiceErrorsResponse> {
        /**
         * <p>
         * An array of <code>ServiceError</code> objects that describe the specified service errors.
         * </p>
         * 
         * @param serviceErrors
         *        An array of <code>ServiceError</code> objects that describe the specified service errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrors(Collection<ServiceError> serviceErrors);

        /**
         * <p>
         * An array of <code>ServiceError</code> objects that describe the specified service errors.
         * </p>
         * 
         * @param serviceErrors
         *        An array of <code>ServiceError</code> objects that describe the specified service errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrors(ServiceError... serviceErrors);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<ServiceError> serviceErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsResponse model) {
            serviceErrors(model.serviceErrors);
        }

        public final Collection<ServiceError.Builder> getServiceErrors() {
            return serviceErrors != null ? serviceErrors.stream().map(ServiceError::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder serviceErrors(Collection<ServiceError> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copy(serviceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrors(ServiceError... serviceErrors) {
            serviceErrors(Arrays.asList(serviceErrors));
            return this;
        }

        public final void setServiceErrors(Collection<ServiceError.BuilderImpl> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copyFromBuilder(serviceErrors);
        }

        @Override
        public DescribeServiceErrorsResponse build() {
            return new DescribeServiceErrorsResponse(this);
        }
    }
}
