/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStackSummary</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackSummaryResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeStackSummaryResponse.Builder, DescribeStackSummaryResponse> {
    private final StackSummary stackSummary;

    private DescribeStackSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.stackSummary = builder.stackSummary;
    }

    /**
     * <p>
     * A <code>StackSummary</code> object that contains the results.
     * </p>
     * 
     * @return A <code>StackSummary</code> object that contains the results.
     */
    public StackSummary stackSummary() {
        return stackSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSummaryResponse)) {
            return false;
        }
        DescribeStackSummaryResponse other = (DescribeStackSummaryResponse) obj;
        return Objects.equals(stackSummary(), other.stackSummary());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackSummary() != null) {
            sb.append("StackSummary: ").append(stackSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSummary":
            return Optional.of(clazz.cast(stackSummary()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends OpsWorksResponse.Builder, CopyableBuilder<Builder, DescribeStackSummaryResponse> {
        /**
         * <p>
         * A <code>StackSummary</code> object that contains the results.
         * </p>
         * 
         * @param stackSummary
         *        A <code>StackSummary</code> object that contains the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSummary(StackSummary stackSummary);

        /**
         * <p>
         * A <code>StackSummary</code> object that contains the results.
         * </p>
         * This is a convenience that creates an instance of the {@link StackSummary.Builder} avoiding the need to
         * create one manually via {@link StackSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #stackSummary(StackSummary)}.
         * 
         * @param stackSummary
         *        a consumer that will call methods on {@link StackSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackSummary(StackSummary)
         */
        default Builder stackSummary(Consumer<StackSummary.Builder> stackSummary) {
            return stackSummary(StackSummary.builder().apply(stackSummary).build());
        }
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private StackSummary stackSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSummaryResponse model) {
            stackSummary(model.stackSummary);
        }

        public final StackSummary.Builder getStackSummary() {
            return stackSummary != null ? stackSummary.toBuilder() : null;
        }

        @Override
        public final Builder stackSummary(StackSummary stackSummary) {
            this.stackSummary = stackSummary;
            return this;
        }

        public final void setStackSummary(StackSummary.BuilderImpl stackSummary) {
            this.stackSummary = stackSummary != null ? stackSummary.build() : null;
        }

        @Override
        public DescribeStackSummaryResponse build() {
            return new DescribeStackSummaryResponse(this);
        }
    }
}
