/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.EcsClusterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a registered Amazon ECS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EcsCluster implements StructuredPojo, ToCopyableBuilder<EcsCluster.Builder, EcsCluster> {
    private final String ecsClusterArn;

    private final String ecsClusterName;

    private final String stackId;

    private final String registeredAt;

    private EcsCluster(BuilderImpl builder) {
        this.ecsClusterArn = builder.ecsClusterArn;
        this.ecsClusterName = builder.ecsClusterName;
        this.stackId = builder.stackId;
        this.registeredAt = builder.registeredAt;
    }

    /**
     * <p>
     * The cluster's ARN.
     * </p>
     * 
     * @return The cluster's ARN.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    /**
     * <p>
     * The cluster name.
     * </p>
     * 
     * @return The cluster name.
     */
    public String ecsClusterName() {
        return ecsClusterName;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The time and date that the cluster was registered with the stack.
     * </p>
     * 
     * @return The time and date that the cluster was registered with the stack.
     */
    public String registeredAt() {
        return registeredAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(registeredAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsCluster)) {
            return false;
        }
        EcsCluster other = (EcsCluster) obj;
        return Objects.equals(ecsClusterArn(), other.ecsClusterArn()) && Objects.equals(ecsClusterName(), other.ecsClusterName())
                && Objects.equals(stackId(), other.stackId()) && Objects.equals(registeredAt(), other.registeredAt());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(ecsClusterArn()).append(",");
        }
        if (ecsClusterName() != null) {
            sb.append("EcsClusterName: ").append(ecsClusterName()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (registeredAt() != null) {
            sb.append("RegisteredAt: ").append(registeredAt()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EcsClusterArn":
            return Optional.of(clazz.cast(ecsClusterArn()));
        case "EcsClusterName":
            return Optional.of(clazz.cast(ecsClusterName()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "RegisteredAt":
            return Optional.of(clazz.cast(registeredAt()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EcsCluster> {
        /**
         * <p>
         * The cluster's ARN.
         * </p>
         * 
         * @param ecsClusterArn
         *        The cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);

        /**
         * <p>
         * The cluster name.
         * </p>
         * 
         * @param ecsClusterName
         *        The cluster name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterName(String ecsClusterName);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The time and date that the cluster was registered with the stack.
         * </p>
         * 
         * @param registeredAt
         *        The time and date that the cluster was registered with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredAt(String registeredAt);
    }

    static final class BuilderImpl implements Builder {
        private String ecsClusterArn;

        private String ecsClusterName;

        private String stackId;

        private String registeredAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsCluster model) {
            ecsClusterArn(model.ecsClusterArn);
            ecsClusterName(model.ecsClusterName);
            stackId(model.stackId);
            registeredAt(model.registeredAt);
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getEcsClusterName() {
            return ecsClusterName;
        }

        @Override
        public final Builder ecsClusterName(String ecsClusterName) {
            this.ecsClusterName = ecsClusterName;
            return this;
        }

        public final void setEcsClusterName(String ecsClusterName) {
            this.ecsClusterName = ecsClusterName;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRegisteredAt() {
            return registeredAt;
        }

        @Override
        public final Builder registeredAt(String registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final void setRegisteredAt(String registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public EcsCluster build() {
            return new EcsCluster(this);
        }
    }
}
