/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.InstancesCountMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how many instances a stack has for each status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstancesCount implements StructuredPojo, ToCopyableBuilder<InstancesCount.Builder, InstancesCount> {
    private final Integer assigning;

    private final Integer booting;

    private final Integer connectionLost;

    private final Integer deregistering;

    private final Integer online;

    private final Integer pending;

    private final Integer rebooting;

    private final Integer registered;

    private final Integer registering;

    private final Integer requested;

    private final Integer runningSetup;

    private final Integer setupFailed;

    private final Integer shuttingDown;

    private final Integer startFailed;

    private final Integer stopped;

    private final Integer stopping;

    private final Integer terminated;

    private final Integer terminating;

    private final Integer unassigning;

    private InstancesCount(BuilderImpl builder) {
        this.assigning = builder.assigning;
        this.booting = builder.booting;
        this.connectionLost = builder.connectionLost;
        this.deregistering = builder.deregistering;
        this.online = builder.online;
        this.pending = builder.pending;
        this.rebooting = builder.rebooting;
        this.registered = builder.registered;
        this.registering = builder.registering;
        this.requested = builder.requested;
        this.runningSetup = builder.runningSetup;
        this.setupFailed = builder.setupFailed;
        this.shuttingDown = builder.shuttingDown;
        this.startFailed = builder.startFailed;
        this.stopped = builder.stopped;
        this.stopping = builder.stopping;
        this.terminated = builder.terminated;
        this.terminating = builder.terminating;
        this.unassigning = builder.unassigning;
    }

    /**
     * <p>
     * The number of instances in the Assigning state.
     * </p>
     * 
     * @return The number of instances in the Assigning state.
     */
    public Integer assigning() {
        return assigning;
    }

    /**
     * <p>
     * The number of instances with <code>booting</code> status.
     * </p>
     * 
     * @return The number of instances with <code>booting</code> status.
     */
    public Integer booting() {
        return booting;
    }

    /**
     * <p>
     * The number of instances with <code>connection_lost</code> status.
     * </p>
     * 
     * @return The number of instances with <code>connection_lost</code> status.
     */
    public Integer connectionLost() {
        return connectionLost;
    }

    /**
     * <p>
     * The number of instances in the Deregistering state.
     * </p>
     * 
     * @return The number of instances in the Deregistering state.
     */
    public Integer deregistering() {
        return deregistering;
    }

    /**
     * <p>
     * The number of instances with <code>online</code> status.
     * </p>
     * 
     * @return The number of instances with <code>online</code> status.
     */
    public Integer online() {
        return online;
    }

    /**
     * <p>
     * The number of instances with <code>pending</code> status.
     * </p>
     * 
     * @return The number of instances with <code>pending</code> status.
     */
    public Integer pending() {
        return pending;
    }

    /**
     * <p>
     * The number of instances with <code>rebooting</code> status.
     * </p>
     * 
     * @return The number of instances with <code>rebooting</code> status.
     */
    public Integer rebooting() {
        return rebooting;
    }

    /**
     * <p>
     * The number of instances in the Registered state.
     * </p>
     * 
     * @return The number of instances in the Registered state.
     */
    public Integer registered() {
        return registered;
    }

    /**
     * <p>
     * The number of instances in the Registering state.
     * </p>
     * 
     * @return The number of instances in the Registering state.
     */
    public Integer registering() {
        return registering;
    }

    /**
     * <p>
     * The number of instances with <code>requested</code> status.
     * </p>
     * 
     * @return The number of instances with <code>requested</code> status.
     */
    public Integer requested() {
        return requested;
    }

    /**
     * <p>
     * The number of instances with <code>running_setup</code> status.
     * </p>
     * 
     * @return The number of instances with <code>running_setup</code> status.
     */
    public Integer runningSetup() {
        return runningSetup;
    }

    /**
     * <p>
     * The number of instances with <code>setup_failed</code> status.
     * </p>
     * 
     * @return The number of instances with <code>setup_failed</code> status.
     */
    public Integer setupFailed() {
        return setupFailed;
    }

    /**
     * <p>
     * The number of instances with <code>shutting_down</code> status.
     * </p>
     * 
     * @return The number of instances with <code>shutting_down</code> status.
     */
    public Integer shuttingDown() {
        return shuttingDown;
    }

    /**
     * <p>
     * The number of instances with <code>start_failed</code> status.
     * </p>
     * 
     * @return The number of instances with <code>start_failed</code> status.
     */
    public Integer startFailed() {
        return startFailed;
    }

    /**
     * <p>
     * The number of instances with <code>stopped</code> status.
     * </p>
     * 
     * @return The number of instances with <code>stopped</code> status.
     */
    public Integer stopped() {
        return stopped;
    }

    /**
     * <p>
     * The number of instances with <code>stopping</code> status.
     * </p>
     * 
     * @return The number of instances with <code>stopping</code> status.
     */
    public Integer stopping() {
        return stopping;
    }

    /**
     * <p>
     * The number of instances with <code>terminated</code> status.
     * </p>
     * 
     * @return The number of instances with <code>terminated</code> status.
     */
    public Integer terminated() {
        return terminated;
    }

    /**
     * <p>
     * The number of instances with <code>terminating</code> status.
     * </p>
     * 
     * @return The number of instances with <code>terminating</code> status.
     */
    public Integer terminating() {
        return terminating;
    }

    /**
     * <p>
     * The number of instances in the Unassigning state.
     * </p>
     * 
     * @return The number of instances in the Unassigning state.
     */
    public Integer unassigning() {
        return unassigning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assigning());
        hashCode = 31 * hashCode + Objects.hashCode(booting());
        hashCode = 31 * hashCode + Objects.hashCode(connectionLost());
        hashCode = 31 * hashCode + Objects.hashCode(deregistering());
        hashCode = 31 * hashCode + Objects.hashCode(online());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(rebooting());
        hashCode = 31 * hashCode + Objects.hashCode(registered());
        hashCode = 31 * hashCode + Objects.hashCode(registering());
        hashCode = 31 * hashCode + Objects.hashCode(requested());
        hashCode = 31 * hashCode + Objects.hashCode(runningSetup());
        hashCode = 31 * hashCode + Objects.hashCode(setupFailed());
        hashCode = 31 * hashCode + Objects.hashCode(shuttingDown());
        hashCode = 31 * hashCode + Objects.hashCode(startFailed());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(stopping());
        hashCode = 31 * hashCode + Objects.hashCode(terminated());
        hashCode = 31 * hashCode + Objects.hashCode(terminating());
        hashCode = 31 * hashCode + Objects.hashCode(unassigning());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancesCount)) {
            return false;
        }
        InstancesCount other = (InstancesCount) obj;
        return Objects.equals(assigning(), other.assigning()) && Objects.equals(booting(), other.booting())
                && Objects.equals(connectionLost(), other.connectionLost())
                && Objects.equals(deregistering(), other.deregistering()) && Objects.equals(online(), other.online())
                && Objects.equals(pending(), other.pending()) && Objects.equals(rebooting(), other.rebooting())
                && Objects.equals(registered(), other.registered()) && Objects.equals(registering(), other.registering())
                && Objects.equals(requested(), other.requested()) && Objects.equals(runningSetup(), other.runningSetup())
                && Objects.equals(setupFailed(), other.setupFailed()) && Objects.equals(shuttingDown(), other.shuttingDown())
                && Objects.equals(startFailed(), other.startFailed()) && Objects.equals(stopped(), other.stopped())
                && Objects.equals(stopping(), other.stopping()) && Objects.equals(terminated(), other.terminated())
                && Objects.equals(terminating(), other.terminating()) && Objects.equals(unassigning(), other.unassigning());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (assigning() != null) {
            sb.append("Assigning: ").append(assigning()).append(",");
        }
        if (booting() != null) {
            sb.append("Booting: ").append(booting()).append(",");
        }
        if (connectionLost() != null) {
            sb.append("ConnectionLost: ").append(connectionLost()).append(",");
        }
        if (deregistering() != null) {
            sb.append("Deregistering: ").append(deregistering()).append(",");
        }
        if (online() != null) {
            sb.append("Online: ").append(online()).append(",");
        }
        if (pending() != null) {
            sb.append("Pending: ").append(pending()).append(",");
        }
        if (rebooting() != null) {
            sb.append("Rebooting: ").append(rebooting()).append(",");
        }
        if (registered() != null) {
            sb.append("Registered: ").append(registered()).append(",");
        }
        if (registering() != null) {
            sb.append("Registering: ").append(registering()).append(",");
        }
        if (requested() != null) {
            sb.append("Requested: ").append(requested()).append(",");
        }
        if (runningSetup() != null) {
            sb.append("RunningSetup: ").append(runningSetup()).append(",");
        }
        if (setupFailed() != null) {
            sb.append("SetupFailed: ").append(setupFailed()).append(",");
        }
        if (shuttingDown() != null) {
            sb.append("ShuttingDown: ").append(shuttingDown()).append(",");
        }
        if (startFailed() != null) {
            sb.append("StartFailed: ").append(startFailed()).append(",");
        }
        if (stopped() != null) {
            sb.append("Stopped: ").append(stopped()).append(",");
        }
        if (stopping() != null) {
            sb.append("Stopping: ").append(stopping()).append(",");
        }
        if (terminated() != null) {
            sb.append("Terminated: ").append(terminated()).append(",");
        }
        if (terminating() != null) {
            sb.append("Terminating: ").append(terminating()).append(",");
        }
        if (unassigning() != null) {
            sb.append("Unassigning: ").append(unassigning()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Assigning":
            return Optional.of(clazz.cast(assigning()));
        case "Booting":
            return Optional.of(clazz.cast(booting()));
        case "ConnectionLost":
            return Optional.of(clazz.cast(connectionLost()));
        case "Deregistering":
            return Optional.of(clazz.cast(deregistering()));
        case "Online":
            return Optional.of(clazz.cast(online()));
        case "Pending":
            return Optional.of(clazz.cast(pending()));
        case "Rebooting":
            return Optional.of(clazz.cast(rebooting()));
        case "Registered":
            return Optional.of(clazz.cast(registered()));
        case "Registering":
            return Optional.of(clazz.cast(registering()));
        case "Requested":
            return Optional.of(clazz.cast(requested()));
        case "RunningSetup":
            return Optional.of(clazz.cast(runningSetup()));
        case "SetupFailed":
            return Optional.of(clazz.cast(setupFailed()));
        case "ShuttingDown":
            return Optional.of(clazz.cast(shuttingDown()));
        case "StartFailed":
            return Optional.of(clazz.cast(startFailed()));
        case "Stopped":
            return Optional.of(clazz.cast(stopped()));
        case "Stopping":
            return Optional.of(clazz.cast(stopping()));
        case "Terminated":
            return Optional.of(clazz.cast(terminated()));
        case "Terminating":
            return Optional.of(clazz.cast(terminating()));
        case "Unassigning":
            return Optional.of(clazz.cast(unassigning()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancesCountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstancesCount> {
        /**
         * <p>
         * The number of instances in the Assigning state.
         * </p>
         * 
         * @param assigning
         *        The number of instances in the Assigning state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assigning(Integer assigning);

        /**
         * <p>
         * The number of instances with <code>booting</code> status.
         * </p>
         * 
         * @param booting
         *        The number of instances with <code>booting</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booting(Integer booting);

        /**
         * <p>
         * The number of instances with <code>connection_lost</code> status.
         * </p>
         * 
         * @param connectionLost
         *        The number of instances with <code>connection_lost</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionLost(Integer connectionLost);

        /**
         * <p>
         * The number of instances in the Deregistering state.
         * </p>
         * 
         * @param deregistering
         *        The number of instances in the Deregistering state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregistering(Integer deregistering);

        /**
         * <p>
         * The number of instances with <code>online</code> status.
         * </p>
         * 
         * @param online
         *        The number of instances with <code>online</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder online(Integer online);

        /**
         * <p>
         * The number of instances with <code>pending</code> status.
         * </p>
         * 
         * @param pending
         *        The number of instances with <code>pending</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * The number of instances with <code>rebooting</code> status.
         * </p>
         * 
         * @param rebooting
         *        The number of instances with <code>rebooting</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebooting(Integer rebooting);

        /**
         * <p>
         * The number of instances in the Registered state.
         * </p>
         * 
         * @param registered
         *        The number of instances in the Registered state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registered(Integer registered);

        /**
         * <p>
         * The number of instances in the Registering state.
         * </p>
         * 
         * @param registering
         *        The number of instances in the Registering state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registering(Integer registering);

        /**
         * <p>
         * The number of instances with <code>requested</code> status.
         * </p>
         * 
         * @param requested
         *        The number of instances with <code>requested</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requested(Integer requested);

        /**
         * <p>
         * The number of instances with <code>running_setup</code> status.
         * </p>
         * 
         * @param runningSetup
         *        The number of instances with <code>running_setup</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningSetup(Integer runningSetup);

        /**
         * <p>
         * The number of instances with <code>setup_failed</code> status.
         * </p>
         * 
         * @param setupFailed
         *        The number of instances with <code>setup_failed</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupFailed(Integer setupFailed);

        /**
         * <p>
         * The number of instances with <code>shutting_down</code> status.
         * </p>
         * 
         * @param shuttingDown
         *        The number of instances with <code>shutting_down</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shuttingDown(Integer shuttingDown);

        /**
         * <p>
         * The number of instances with <code>start_failed</code> status.
         * </p>
         * 
         * @param startFailed
         *        The number of instances with <code>start_failed</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFailed(Integer startFailed);

        /**
         * <p>
         * The number of instances with <code>stopped</code> status.
         * </p>
         * 
         * @param stopped
         *        The number of instances with <code>stopped</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Integer stopped);

        /**
         * <p>
         * The number of instances with <code>stopping</code> status.
         * </p>
         * 
         * @param stopping
         *        The number of instances with <code>stopping</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopping(Integer stopping);

        /**
         * <p>
         * The number of instances with <code>terminated</code> status.
         * </p>
         * 
         * @param terminated
         *        The number of instances with <code>terminated</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminated(Integer terminated);

        /**
         * <p>
         * The number of instances with <code>terminating</code> status.
         * </p>
         * 
         * @param terminating
         *        The number of instances with <code>terminating</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminating(Integer terminating);

        /**
         * <p>
         * The number of instances in the Unassigning state.
         * </p>
         * 
         * @param unassigning
         *        The number of instances in the Unassigning state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassigning(Integer unassigning);
    }

    static final class BuilderImpl implements Builder {
        private Integer assigning;

        private Integer booting;

        private Integer connectionLost;

        private Integer deregistering;

        private Integer online;

        private Integer pending;

        private Integer rebooting;

        private Integer registered;

        private Integer registering;

        private Integer requested;

        private Integer runningSetup;

        private Integer setupFailed;

        private Integer shuttingDown;

        private Integer startFailed;

        private Integer stopped;

        private Integer stopping;

        private Integer terminated;

        private Integer terminating;

        private Integer unassigning;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancesCount model) {
            assigning(model.assigning);
            booting(model.booting);
            connectionLost(model.connectionLost);
            deregistering(model.deregistering);
            online(model.online);
            pending(model.pending);
            rebooting(model.rebooting);
            registered(model.registered);
            registering(model.registering);
            requested(model.requested);
            runningSetup(model.runningSetup);
            setupFailed(model.setupFailed);
            shuttingDown(model.shuttingDown);
            startFailed(model.startFailed);
            stopped(model.stopped);
            stopping(model.stopping);
            terminated(model.terminated);
            terminating(model.terminating);
            unassigning(model.unassigning);
        }

        public final Integer getAssigning() {
            return assigning;
        }

        @Override
        public final Builder assigning(Integer assigning) {
            this.assigning = assigning;
            return this;
        }

        public final void setAssigning(Integer assigning) {
            this.assigning = assigning;
        }

        public final Integer getBooting() {
            return booting;
        }

        @Override
        public final Builder booting(Integer booting) {
            this.booting = booting;
            return this;
        }

        public final void setBooting(Integer booting) {
            this.booting = booting;
        }

        public final Integer getConnectionLost() {
            return connectionLost;
        }

        @Override
        public final Builder connectionLost(Integer connectionLost) {
            this.connectionLost = connectionLost;
            return this;
        }

        public final void setConnectionLost(Integer connectionLost) {
            this.connectionLost = connectionLost;
        }

        public final Integer getDeregistering() {
            return deregistering;
        }

        @Override
        public final Builder deregistering(Integer deregistering) {
            this.deregistering = deregistering;
            return this;
        }

        public final void setDeregistering(Integer deregistering) {
            this.deregistering = deregistering;
        }

        public final Integer getOnline() {
            return online;
        }

        @Override
        public final Builder online(Integer online) {
            this.online = online;
            return this;
        }

        public final void setOnline(Integer online) {
            this.online = online;
        }

        public final Integer getPending() {
            return pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        public final Integer getRebooting() {
            return rebooting;
        }

        @Override
        public final Builder rebooting(Integer rebooting) {
            this.rebooting = rebooting;
            return this;
        }

        public final void setRebooting(Integer rebooting) {
            this.rebooting = rebooting;
        }

        public final Integer getRegistered() {
            return registered;
        }

        @Override
        public final Builder registered(Integer registered) {
            this.registered = registered;
            return this;
        }

        public final void setRegistered(Integer registered) {
            this.registered = registered;
        }

        public final Integer getRegistering() {
            return registering;
        }

        @Override
        public final Builder registering(Integer registering) {
            this.registering = registering;
            return this;
        }

        public final void setRegistering(Integer registering) {
            this.registering = registering;
        }

        public final Integer getRequested() {
            return requested;
        }

        @Override
        public final Builder requested(Integer requested) {
            this.requested = requested;
            return this;
        }

        public final void setRequested(Integer requested) {
            this.requested = requested;
        }

        public final Integer getRunningSetup() {
            return runningSetup;
        }

        @Override
        public final Builder runningSetup(Integer runningSetup) {
            this.runningSetup = runningSetup;
            return this;
        }

        public final void setRunningSetup(Integer runningSetup) {
            this.runningSetup = runningSetup;
        }

        public final Integer getSetupFailed() {
            return setupFailed;
        }

        @Override
        public final Builder setupFailed(Integer setupFailed) {
            this.setupFailed = setupFailed;
            return this;
        }

        public final void setSetupFailed(Integer setupFailed) {
            this.setupFailed = setupFailed;
        }

        public final Integer getShuttingDown() {
            return shuttingDown;
        }

        @Override
        public final Builder shuttingDown(Integer shuttingDown) {
            this.shuttingDown = shuttingDown;
            return this;
        }

        public final void setShuttingDown(Integer shuttingDown) {
            this.shuttingDown = shuttingDown;
        }

        public final Integer getStartFailed() {
            return startFailed;
        }

        @Override
        public final Builder startFailed(Integer startFailed) {
            this.startFailed = startFailed;
            return this;
        }

        public final void setStartFailed(Integer startFailed) {
            this.startFailed = startFailed;
        }

        public final Integer getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Integer stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Integer stopped) {
            this.stopped = stopped;
        }

        public final Integer getStopping() {
            return stopping;
        }

        @Override
        public final Builder stopping(Integer stopping) {
            this.stopping = stopping;
            return this;
        }

        public final void setStopping(Integer stopping) {
            this.stopping = stopping;
        }

        public final Integer getTerminated() {
            return terminated;
        }

        @Override
        public final Builder terminated(Integer terminated) {
            this.terminated = terminated;
            return this;
        }

        public final void setTerminated(Integer terminated) {
            this.terminated = terminated;
        }

        public final Integer getTerminating() {
            return terminating;
        }

        @Override
        public final Builder terminating(Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        public final void setTerminating(Integer terminating) {
            this.terminating = terminating;
        }

        public final Integer getUnassigning() {
            return unassigning;
        }

        @Override
        public final Builder unassigning(Integer unassigning) {
            this.unassigning = unassigning;
            return this;
        }

        public final void setUnassigning(Integer unassigning) {
            this.unassigning = unassigning;
        }

        @Override
        public InstancesCount build() {
            return new InstancesCount(this);
        }
    }
}
