/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.opsworks.transform.LayerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Layer implements StructuredPojo, ToCopyableBuilder<Layer.Builder, Layer> {
    private final String arn;

    private final String stackId;

    private final String layerId;

    private final String type;

    private final String name;

    private final String shortname;

    private final Map<String, String> attributes;

    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

    private final String customInstanceProfileArn;

    private final String customJson;

    private final List<String> customSecurityGroupIds;

    private final List<String> defaultSecurityGroupNames;

    private final List<String> packages;

    private final List<VolumeConfiguration> volumeConfigurations;

    private final Boolean enableAutoHealing;

    private final Boolean autoAssignElasticIps;

    private final Boolean autoAssignPublicIps;

    private final Recipes defaultRecipes;

    private final Recipes customRecipes;

    private final String createdAt;

    private final Boolean installUpdatesOnBoot;

    private final Boolean useEbsOptimizedInstances;

    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private Layer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.type = builder.type;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.defaultSecurityGroupNames = builder.defaultSecurityGroupNames;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.defaultRecipes = builder.defaultRecipes;
        this.customRecipes = builder.customRecipes;
        this.createdAt = builder.createdAt;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The layer stack ID.
     * </p>
     * 
     * @return The layer stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The layer type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The layer type.
     * @see LayerType
     */
    public LayerType type() {
        return LayerType.fromValue(type);
    }

    /**
     * <p>
     * The layer type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The layer type.
     * @see LayerType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The layer name.
     * </p>
     * 
     * @return The layer name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The layer short name.
     * </p>
     * 
     * @return The layer short name.
     */
    public String shortname() {
        return shortname;
    }

    /**
     * <p>
     * The layer attributes.
     * </p>
     * <p>
     * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
     * attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
     * </p>
     * <p>
     * For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's
     * ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The layer attributes.</p>
     *         <p>
     *         For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
     *         <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
     *         instead of the actual value
     *         </p>
     *         <p>
     *         For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
     *         cluster's ARN.
     */
    public Map<LayerAttributesKeys, String> attributes() {
        return TypeConverter.convert(attributes, LayerAttributesKeys::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, LayerAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * The layer attributes.
     * </p>
     * <p>
     * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
     * attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
     * </p>
     * <p>
     * For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's
     * ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The layer attributes.</p>
     *         <p>
     *         For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
     *         <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
     *         instead of the actual value
     *         </p>
     *         <p>
     *         For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
     *         cluster's ARN.
     */
    public Map<String, String> attributesStrings() {
        return attributes;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration settings for the layer.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration settings for the layer.
     */
    public CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs,
     * see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about
     *         IAM ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     *         Identifiers</a>.
     */
    public String customInstanceProfileArn() {
        return customInstanceProfileArn;
    }

    /**
     * <p>
     * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
     * </p>
     * 
     * @return A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * An array containing the layer's custom security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array containing the layer's custom security group IDs.
     */
    public List<String> customSecurityGroupIds() {
        return customSecurityGroupIds;
    }

    /**
     * <p>
     * An array containing the layer's security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array containing the layer's security group names.
     */
    public List<String> defaultSecurityGroupNames() {
        return defaultSecurityGroupNames;
    }

    /**
     * <p>
     * An array of <code>Package</code> objects that describe the layer's packages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Package</code> objects that describe the layer's packages.
     */
    public List<String> packages() {
        return packages;
    }

    /**
     * <p>
     * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     */
    public List<VolumeConfiguration> volumeConfigurations() {
        return volumeConfigurations;
    }

    /**
     * <p>
     * Whether auto healing is disabled for the layer.
     * </p>
     * 
     * @return Whether auto healing is disabled for the layer.
     */
    public Boolean enableAutoHealing() {
        return enableAutoHealing;
    }

    /**
     * <p>
     * Whether to automatically assign an <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to
     * the layer's instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return Whether to automatically assign an <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     *         address</a> to the layer's instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignElasticIps() {
        return autoAssignElasticIps;
    }

    /**
     * <p>
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     * instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     *         instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignPublicIps() {
        return autoAssignPublicIps;
    }

    /**
     * Returns the value of the DefaultRecipes property for this object.
     * 
     * @return The value of the DefaultRecipes property for this object.
     */
    public Recipes defaultRecipes() {
        return defaultRecipes;
    }

    /**
     * <p>
     * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     * </p>
     * 
     * @return A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     */
    public Recipes customRecipes() {
        return customRecipes;
    }

    /**
     * <p>
     * Date when the layer was created.
     * </p>
     * 
     * @return Date when the layer was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually by
     * using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually running
     * <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
     *         manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
     *         manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
     *         <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * Whether the layer uses Amazon EBS-optimized instances.
     * </p>
     * 
     * @return Whether the layer uses Amazon EBS-optimized instances.
     */
    public Boolean useEbsOptimizedInstances() {
        return useEbsOptimizedInstances;
    }

    /**
     * <p>
     * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
     * </p>
     * 
     * @return A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
     */
    public LifecycleEventConfiguration lifecycleEventConfiguration() {
        return lifecycleEventConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortname());
        hashCode = 31 * hashCode + Objects.hashCode(attributesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(customJson());
        hashCode = 31 * hashCode + Objects.hashCode(customSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSecurityGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(packages());
        hashCode = 31 * hashCode + Objects.hashCode(volumeConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoHealing());
        hashCode = 31 * hashCode + Objects.hashCode(autoAssignElasticIps());
        hashCode = 31 * hashCode + Objects.hashCode(autoAssignPublicIps());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(customRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(useEbsOptimizedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleEventConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(layerId(), other.layerId()) && Objects.equals(typeString(), other.typeString())
                && Objects.equals(name(), other.name()) && Objects.equals(shortname(), other.shortname())
                && Objects.equals(attributesStrings(), other.attributesStrings())
                && Objects.equals(cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration())
                && Objects.equals(customInstanceProfileArn(), other.customInstanceProfileArn())
                && Objects.equals(customJson(), other.customJson())
                && Objects.equals(customSecurityGroupIds(), other.customSecurityGroupIds())
                && Objects.equals(defaultSecurityGroupNames(), other.defaultSecurityGroupNames())
                && Objects.equals(packages(), other.packages())
                && Objects.equals(volumeConfigurations(), other.volumeConfigurations())
                && Objects.equals(enableAutoHealing(), other.enableAutoHealing())
                && Objects.equals(autoAssignElasticIps(), other.autoAssignElasticIps())
                && Objects.equals(autoAssignPublicIps(), other.autoAssignPublicIps())
                && Objects.equals(defaultRecipes(), other.defaultRecipes())
                && Objects.equals(customRecipes(), other.customRecipes()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(installUpdatesOnBoot(), other.installUpdatesOnBoot())
                && Objects.equals(useEbsOptimizedInstances(), other.useEbsOptimizedInstances())
                && Objects.equals(lifecycleEventConfiguration(), other.lifecycleEventConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (layerId() != null) {
            sb.append("LayerId: ").append(layerId()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (shortname() != null) {
            sb.append("Shortname: ").append(shortname()).append(",");
        }
        if (attributesStrings() != null) {
            sb.append("Attributes: ").append(attributesStrings()).append(",");
        }
        if (cloudWatchLogsConfiguration() != null) {
            sb.append("CloudWatchLogsConfiguration: ").append(cloudWatchLogsConfiguration()).append(",");
        }
        if (customInstanceProfileArn() != null) {
            sb.append("CustomInstanceProfileArn: ").append(customInstanceProfileArn()).append(",");
        }
        if (customJson() != null) {
            sb.append("CustomJson: ").append(customJson()).append(",");
        }
        if (customSecurityGroupIds() != null) {
            sb.append("CustomSecurityGroupIds: ").append(customSecurityGroupIds()).append(",");
        }
        if (defaultSecurityGroupNames() != null) {
            sb.append("DefaultSecurityGroupNames: ").append(defaultSecurityGroupNames()).append(",");
        }
        if (packages() != null) {
            sb.append("Packages: ").append(packages()).append(",");
        }
        if (volumeConfigurations() != null) {
            sb.append("VolumeConfigurations: ").append(volumeConfigurations()).append(",");
        }
        if (enableAutoHealing() != null) {
            sb.append("EnableAutoHealing: ").append(enableAutoHealing()).append(",");
        }
        if (autoAssignElasticIps() != null) {
            sb.append("AutoAssignElasticIps: ").append(autoAssignElasticIps()).append(",");
        }
        if (autoAssignPublicIps() != null) {
            sb.append("AutoAssignPublicIps: ").append(autoAssignPublicIps()).append(",");
        }
        if (defaultRecipes() != null) {
            sb.append("DefaultRecipes: ").append(defaultRecipes()).append(",");
        }
        if (customRecipes() != null) {
            sb.append("CustomRecipes: ").append(customRecipes()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(installUpdatesOnBoot()).append(",");
        }
        if (useEbsOptimizedInstances() != null) {
            sb.append("UseEbsOptimizedInstances: ").append(useEbsOptimizedInstances()).append(",");
        }
        if (lifecycleEventConfiguration() != null) {
            sb.append("LifecycleEventConfiguration: ").append(lifecycleEventConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "LayerId":
            return Optional.of(clazz.cast(layerId()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Shortname":
            return Optional.of(clazz.cast(shortname()));
        case "Attributes":
            return Optional.of(clazz.cast(attributesStrings()));
        case "CloudWatchLogsConfiguration":
            return Optional.of(clazz.cast(cloudWatchLogsConfiguration()));
        case "CustomInstanceProfileArn":
            return Optional.of(clazz.cast(customInstanceProfileArn()));
        case "CustomJson":
            return Optional.of(clazz.cast(customJson()));
        case "CustomSecurityGroupIds":
            return Optional.of(clazz.cast(customSecurityGroupIds()));
        case "DefaultSecurityGroupNames":
            return Optional.of(clazz.cast(defaultSecurityGroupNames()));
        case "Packages":
            return Optional.of(clazz.cast(packages()));
        case "VolumeConfigurations":
            return Optional.of(clazz.cast(volumeConfigurations()));
        case "EnableAutoHealing":
            return Optional.of(clazz.cast(enableAutoHealing()));
        case "AutoAssignElasticIps":
            return Optional.of(clazz.cast(autoAssignElasticIps()));
        case "AutoAssignPublicIps":
            return Optional.of(clazz.cast(autoAssignPublicIps()));
        case "DefaultRecipes":
            return Optional.of(clazz.cast(defaultRecipes()));
        case "CustomRecipes":
            return Optional.of(clazz.cast(customRecipes()));
        case "CreatedAt":
            return Optional.of(clazz.cast(createdAt()));
        case "InstallUpdatesOnBoot":
            return Optional.of(clazz.cast(installUpdatesOnBoot()));
        case "UseEbsOptimizedInstances":
            return Optional.of(clazz.cast(useEbsOptimizedInstances()));
        case "LifecycleEventConfiguration":
            return Optional.of(clazz.cast(lifecycleEventConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Layer> {
        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The layer stack ID.
         * </p>
         * 
         * @param stackId
         *        The layer stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param type
         *        The layer type.
         * @see LayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(String type);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param type
         *        The layer type.
         * @see LayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(LayerType type);

        /**
         * <p>
         * The layer name.
         * </p>
         * 
         * @param name
         *        The layer name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The layer short name.
         * </p>
         * 
         * @param shortname
         *        The layer short name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortname(String shortname);

        /**
         * <p>
         * The layer attributes.
         * </p>
         * <p>
         * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
         * attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
         * </p>
         * <p>
         * For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
         * cluster's ARN.
         * </p>
         * 
         * @param attributes
         *        The layer attributes.</p>
         *        <p>
         *        For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
         *        <code>GangliaPassword</code> attributes, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code>
         *        instead of the actual value
         *        </p>
         *        <p>
         *        For an ECS Cluster layer, AWS OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
         *        cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration settings for the layer.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        The Amazon CloudWatch Logs configuration settings for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration settings for the layer.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLogsConfiguration.Builder} avoiding
         * the need to create one manually via {@link CloudWatchLogsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLogsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogsConfiguration(CloudWatchLogsConfiguration)}.
         * 
         * @param cloudWatchLogsConfiguration
         *        a consumer that will call methods on {@link CloudWatchLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsConfiguration(CloudWatchLogsConfiguration)
         */
        default Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfiguration.Builder> cloudWatchLogsConfiguration) {
            return cloudWatchLogsConfiguration(CloudWatchLogsConfiguration.builder().apply(cloudWatchLogsConfiguration).build());
        }

        /**
         * <p>
         * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM
         * ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         * Identifiers</a>.
         * </p>
         * 
         * @param customInstanceProfileArn
         *        The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information
         *        about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstanceProfileArn(String customInstanceProfileArn);

        /**
         * <p>
         * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
         * </p>
         * 
         * @param customJson
         *        A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(String... customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer's security group names.
         * </p>
         * 
         * @param defaultSecurityGroupNames
         *        An array containing the layer's security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames);

        /**
         * <p>
         * An array containing the layer's security group names.
         * </p>
         * 
         * @param defaultSecurityGroupNames
         *        An array containing the layer's security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSecurityGroupNames(String... defaultSecurityGroupNames);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(Collection<String> packages);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(String... packages);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations);

        /**
         * <p>
         * Whether auto healing is disabled for the layer.
         * </p>
         * 
         * @param enableAutoHealing
         *        Whether auto healing is disabled for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoHealing(Boolean enableAutoHealing);

        /**
         * <p>
         * Whether to automatically assign an <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         * address</a> to the layer's instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignElasticIps
         *        Whether to automatically assign an <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         *        address</a> to the layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignElasticIps(Boolean autoAssignElasticIps);

        /**
         * <p>
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
         * instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignPublicIps
         *        For stacks that are running in a VPC, whether to automatically assign a public IP address to the
         *        layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignPublicIps(Boolean autoAssignPublicIps);

        /**
         * Sets the value of the DefaultRecipes property for this object.
         *
         * @param defaultRecipes
         *        The new value for the DefaultRecipes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRecipes(Recipes defaultRecipes);

        /**
         * Sets the value of the DefaultRecipes property for this object.
         *
         * This is a convenience that creates an instance of the {@link Recipes.Builder} avoiding the need to create one
         * manually via {@link Recipes#builder()}.
         *
         * When the {@link Consumer} completes, {@link Recipes.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultRecipes(Recipes)}.
         * 
         * @param defaultRecipes
         *        a consumer that will call methods on {@link Recipes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRecipes(Recipes)
         */
        default Builder defaultRecipes(Consumer<Recipes.Builder> defaultRecipes) {
            return defaultRecipes(Recipes.builder().apply(defaultRecipes).build());
        }

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * </p>
         * 
         * @param customRecipes
         *        A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRecipes(Recipes customRecipes);

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * </p>
         * This is a convenience that creates an instance of the {@link Recipes.Builder} avoiding the need to create one
         * manually via {@link Recipes#builder()}.
         *
         * When the {@link Consumer} completes, {@link Recipes.Builder#build()} is called immediately and its result is
         * passed to {@link #customRecipes(Recipes)}.
         * 
         * @param customRecipes
         *        a consumer that will call methods on {@link Recipes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRecipes(Recipes)
         */
        default Builder customRecipes(Consumer<Recipes.Builder> customRecipes) {
            return customRecipes(Recipes.builder().apply(customRecipes).build());
        }

        /**
         * <p>
         * Date when the layer was created.
         * </p>
         * 
         * @param createdAt
         *        Date when the layer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually
         * by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually
         * running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
         *        manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
         *        manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *        </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * Whether the layer uses Amazon EBS-optimized instances.
         * </p>
         * 
         * @param useEbsOptimizedInstances
         *        Whether the layer uses Amazon EBS-optimized instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances);

        /**
         * <p>
         * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * 
         * @param lifecycleEventConfiguration
         *        A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration);

        /**
         * <p>
         * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link LifecycleEventConfiguration.Builder} avoiding
         * the need to create one manually via {@link LifecycleEventConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifecycleEventConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycleEventConfiguration(LifecycleEventConfiguration)}.
         * 
         * @param lifecycleEventConfiguration
         *        a consumer that will call methods on {@link LifecycleEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleEventConfiguration(LifecycleEventConfiguration)
         */
        default Builder lifecycleEventConfiguration(Consumer<LifecycleEventConfiguration.Builder> lifecycleEventConfiguration) {
            return lifecycleEventConfiguration(LifecycleEventConfiguration.builder().apply(lifecycleEventConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String stackId;

        private String layerId;

        private String type;

        private String name;

        private String shortname;

        private Map<String, String> attributes;

        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

        private String customInstanceProfileArn;

        private String customJson;

        private List<String> customSecurityGroupIds;

        private List<String> defaultSecurityGroupNames;

        private List<String> packages;

        private List<VolumeConfiguration> volumeConfigurations;

        private Boolean enableAutoHealing;

        private Boolean autoAssignElasticIps;

        private Boolean autoAssignPublicIps;

        private Recipes defaultRecipes;

        private Recipes customRecipes;

        private String createdAt;

        private Boolean installUpdatesOnBoot;

        private Boolean useEbsOptimizedInstances;

        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            arn(model.arn);
            stackId(model.stackId);
            layerId(model.layerId);
            type(model.type);
            name(model.name);
            shortname(model.shortname);
            attributes(model.attributes);
            cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            customInstanceProfileArn(model.customInstanceProfileArn);
            customJson(model.customJson);
            customSecurityGroupIds(model.customSecurityGroupIds);
            defaultSecurityGroupNames(model.defaultSecurityGroupNames);
            packages(model.packages);
            volumeConfigurations(model.volumeConfigurations);
            enableAutoHealing(model.enableAutoHealing);
            autoAssignElasticIps(model.autoAssignElasticIps);
            autoAssignPublicIps(model.autoAssignPublicIps);
            defaultRecipes(model.defaultRecipes);
            customRecipes(model.customRecipes);
            createdAt(model.createdAt);
            installUpdatesOnBoot(model.installUpdatesOnBoot);
            useEbsOptimizedInstances(model.useEbsOptimizedInstances);
            lifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LayerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortname() {
            return shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        public final CloudWatchLogsConfiguration.Builder getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        public final String getCustomInstanceProfileArn() {
            return customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            return customSecurityGroupIds;
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String... customSecurityGroupIds) {
            customSecurityGroupIds(Arrays.asList(customSecurityGroupIds));
            return this;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        public final Collection<String> getDefaultSecurityGroupNames() {
            return defaultSecurityGroupNames;
        }

        @Override
        public final Builder defaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSecurityGroupNames(String... defaultSecurityGroupNames) {
            defaultSecurityGroupNames(Arrays.asList(defaultSecurityGroupNames));
            return this;
        }

        public final void setDefaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
        }

        public final Collection<String> getPackages() {
            return packages;
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String... packages) {
            packages(Arrays.asList(packages));
            return this;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        public final Collection<VolumeConfiguration.Builder> getVolumeConfigurations() {
            return volumeConfigurations != null ? volumeConfigurations.stream().map(VolumeConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations) {
            volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        public final Boolean getEnableAutoHealing() {
            return enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        public final Boolean getAutoAssignElasticIps() {
            return autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        public final Boolean getAutoAssignPublicIps() {
            return autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        public final Recipes.Builder getDefaultRecipes() {
            return defaultRecipes != null ? defaultRecipes.toBuilder() : null;
        }

        @Override
        public final Builder defaultRecipes(Recipes defaultRecipes) {
            this.defaultRecipes = defaultRecipes;
            return this;
        }

        public final void setDefaultRecipes(Recipes.BuilderImpl defaultRecipes) {
            this.defaultRecipes = defaultRecipes != null ? defaultRecipes.build() : null;
        }

        public final Recipes.Builder getCustomRecipes() {
            return customRecipes != null ? customRecipes.toBuilder() : null;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final void setCustomRecipes(Recipes.BuilderImpl customRecipes) {
            this.customRecipes = customRecipes != null ? customRecipes.build() : null;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        public final LifecycleEventConfiguration.Builder getLifecycleEventConfiguration() {
            return lifecycleEventConfiguration != null ? lifecycleEventConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration.BuilderImpl lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration != null ? lifecycleEventConfiguration.build() : null;
        }

        @Override
        public Layer build() {
            return new Layer(this);
        }
    }
}
